/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class AuctionTradeData
extends TradeData {
    private boolean cancelled;
    private String persistentID = "";
    CoinValue lastBidAmount = new CoinValue(new CoinValue.CoinValuePair[0]);
    PlayerReference lastBidPlayer = null;
    CoinValue minBidDifference = new CoinValue(1L);
    PlayerReference tradeOwner;
    long startTime = 0L;
    long duration = 0L;
    List<class_1799> auctionItems = new ArrayList<class_1799>();

    public static long GetMinimumDuration() {
        if ((Integer)LCConfig.SERVER.auctionHouseDurationMin.get() > 0) {
            return 86400000L * (long)((Integer)LCConfig.SERVER.auctionHouseDurationMin.get()).intValue();
        }
        return 3600000L;
    }

    public static long GetDefaultDuration() {
        if ((Integer)LCConfig.SERVER.auctionHouseDurationMax.get() > 0) {
            return 86400000L * (long)((Integer)LCConfig.SERVER.auctionHouseDurationMax.get()).intValue();
        }
        return 86400000L;
    }

    public boolean hasBid() {
        return this.lastBidPlayer != null;
    }

    public boolean isPersistentID(String id) {
        return this.persistentID.equals(id);
    }

    public CoinValue getLastBidAmount() {
        return this.lastBidAmount;
    }

    public PlayerReference getLastBidPlayer() {
        return this.lastBidPlayer;
    }

    public void setStartingBid(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.lastBidAmount = amount.copy();
    }

    public CoinValue getMinBidDifference() {
        return this.minBidDifference;
    }

    public void setMinBidDifferent(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.minBidDifference = amount.copy();
        if (this.minBidDifference.getRawValue() <= 0L) {
            this.minBidDifference = new CoinValue(1L);
        }
    }

    public PlayerReference getOwner() {
        return this.tradeOwner;
    }

    public boolean isOwner(class_1657 player) {
        return this.tradeOwner != null && this.tradeOwner.is((class_1297)player) || CommandLCAdmin.isAdminPlayer(player);
    }

    public void setDuration(long duration) {
        if (this.isActive()) {
            return;
        }
        this.duration = Math.max(AuctionTradeData.GetMinimumDuration(), duration);
    }

    public List<class_1799> getAuctionItems() {
        return this.auctionItems;
    }

    public void setAuctionItems(class_1263 auctionItems) {
        if (this.isActive()) {
            return;
        }
        this.auctionItems.clear();
        for (int i = 0; i < auctionItems.method_5439(); ++i) {
            class_1799 stack = auctionItems.method_5438(i);
            if (stack.method_7960()) continue;
            this.auctionItems.add(stack.method_7972());
        }
    }

    public AuctionTradeData(class_1657 owner) {
        super(false);
        this.tradeOwner = PlayerReference.of(owner);
        this.setDuration(AuctionTradeData.GetDefaultDuration());
    }

    public AuctionTradeData(class_2487 compound) {
        super(false);
        this.loadFromNBT(compound);
    }

    public AuctionTradeData(PersistentAuctionData data) {
        super(false);
        this.persistentID = data.id;
        this.setDuration(data.duration);
        this.auctionItems = data.getAuctionItems();
        this.setStartingBid(data.getStartingBid());
        this.setMinBidDifferent(data.getMinimumBidDifference());
    }

    public boolean isActive() {
        return this.startTime != 0L && !this.cancelled;
    }

    @Override
    public boolean isValid() {
        if (this.cancelled) {
            return false;
        }
        if (this.auctionItems.size() <= 0) {
            return false;
        }
        if (this.isActive() && this.hasExpired(TimeUtil.getCurrentTime())) {
            return false;
        }
        if (this.minBidDifference.getRawValue() <= 0L) {
            return false;
        }
        return this.lastBidAmount.getRawValue() > 0L;
    }

    public void startTimer() {
        if (!this.isActive()) {
            this.startTime = TimeUtil.getCurrentTime();
        }
    }

    public long getRemainingTime(long currentTime) {
        if (!this.isActive()) {
            return this.duration;
        }
        return Math.max(0L, this.startTime + this.duration - currentTime);
    }

    public boolean hasExpired(long time) {
        if (this.isActive()) {
            return time >= this.startTime + this.duration;
        }
        return false;
    }

    public boolean tryMakeBid(AuctionHouseTrader trader, class_1657 player, CoinValue amount) {
        if (!this.validateBidAmount(amount)) {
            return false;
        }
        PlayerReference oldBidder = this.lastBidPlayer;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage storage = trader.getStorage(this.lastBidPlayer);
            storage.giveMoney(this.lastBidAmount);
            trader.markStorageDirty();
        }
        this.lastBidPlayer = PlayerReference.of(player);
        this.lastBidAmount = amount.copy();
        if (oldBidder != null) {
            NotificationSaveData.PushNotification(oldBidder.id, new AuctionHouseBidNotification(this));
        }
        return true;
    }

    public boolean validateBidAmount(CoinValue amount) {
        CoinValue minAmount = this.getMinNextBid();
        return amount.getRawValue() >= minAmount.getRawValue();
    }

    public CoinValue getMinNextBid() {
        return new CoinValue(this.lastBidPlayer == null ? this.lastBidAmount.getRawValue() : this.lastBidAmount.getRawValue() + this.minBidDifference.getRawValue());
    }

    public void ExecuteTrade(AuctionHouseTrader trader) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            List<class_1799> rewards = this.getAuctionItems();
            for (int i = 0; i < rewards.size(); ++i) {
                buyerStorage.giveItem(rewards.get(i));
            }
            if (this.tradeOwner != null) {
                AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
                sellerStorage.giveMoney(this.lastBidAmount);
            }
            NotificationSaveData.PushNotification(this.lastBidPlayer.id, new AuctionHouseBuyerNotification(this));
            if (this.tradeOwner != null) {
                NotificationSaveData.PushNotification(this.tradeOwner.id, new AuctionHouseSellerNotification(this));
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            List<class_1799> items = this.getAuctionItems();
            for (int i = 0; i < items.size(); ++i) {
                sellerStorage.giveItem(items.get(i));
            }
            NotificationSaveData.PushNotification(this.tradeOwner.id, new AuctionHouseSellerNobidNotification(this));
        }
    }

    public void CancelTrade(AuctionHouseTrader trader, boolean giveToPlayer, class_1657 player) {
        block5: {
            block4: {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                if (this.lastBidPlayer != null) {
                    AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
                    buyerStorage.giveMoney(this.lastBidAmount);
                    NotificationSaveData.PushNotification(this.lastBidPlayer.id, new AuctionHouseCancelNotification(this));
                }
                if (!giveToPlayer) break block4;
                for (class_1799 stack : this.auctionItems) {
                    InventoryUtil.GiveToPlayer(player, stack);
                }
                break block5;
            }
            if (this.tradeOwner == null) break block5;
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner != null ? this.tradeOwner : PlayerReference.of(player));
            for (class_1799 stack : this.auctionItems) {
                sellerStorage.giveItem(stack);
            }
        }
    }

    @Override
    public class_2487 getAsNBT() {
        class_2487 compound = new class_2487();
        class_2499 itemList = new class_2499();
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            itemList.add((Object)this.auctionItems.get(i).method_7953(new class_2487()));
        }
        compound.method_10566("SellItems", (class_2520)itemList);
        this.lastBidAmount.save(compound, "LastBid");
        if (this.lastBidPlayer != null) {
            compound.method_10566("LastBidPlayer", (class_2520)this.lastBidPlayer.save());
        }
        this.minBidDifference.save(compound, "MinBid");
        compound.method_10544("StartTime", this.startTime);
        compound.method_10544("Duration", this.duration);
        if (this.tradeOwner != null) {
            compound.method_10566("TradeOwner", (class_2520)this.tradeOwner.save());
        }
        compound.method_10556("Cancelled", this.cancelled);
        if (!this.persistentID.isBlank()) {
            compound.method_10582("PersistentID", this.persistentID);
        }
        return compound;
    }

    public JsonObject saveToJson(JsonObject json) {
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            json.add("Item" + String.valueOf(i + 1), (JsonElement)FileUtil.convertItemStack(this.auctionItems.get(i)));
        }
        json.addProperty("Duration", (Number)this.duration);
        json.add("StartingBid", this.lastBidAmount.toJson());
        json.add("MinimumBid", this.minBidDifference.toJson());
        return json;
    }

    @Override
    public void loadFromNBT(class_2487 compound) {
        class_2499 itemList = compound.method_10554("SellItems", 10);
        this.auctionItems.clear();
        for (int i = 0; i < itemList.size(); ++i) {
            class_1799 stack = class_1799.method_7915((class_2487)itemList.method_10602(i));
            if (stack.method_7960()) continue;
            this.auctionItems.add(stack);
        }
        this.lastBidAmount.load(compound, "LastBid");
        this.lastBidPlayer = compound.method_10545("LastBidPlayer") ? PlayerReference.load(compound.method_10562("LastBidPlayer")) : null;
        this.minBidDifference.load(compound, "MinBid");
        this.startTime = compound.method_10537("StartTime");
        this.duration = compound.method_10537("Duration");
        if (compound.method_10573("TradeOwner", 10)) {
            this.tradeOwner = PlayerReference.load(compound.method_10562("TradeOwner"));
        }
        this.cancelled = compound.method_10577("Cancelled");
        if (compound.method_10573("PersistentID", 8)) {
            this.persistentID = compound.method_10558("PersistentID");
        }
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(58, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public boolean hasAlert(TradeContext context) {
        return false;
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(this.lastBidAmount, this.getBidInfo(), true)});
    }

    private List<class_2561> getBidInfo() {
        ArrayList<class_2561> bidInfo = new ArrayList<class_2561>();
        if (this.lastBidPlayer == null) {
            bidInfo.add((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.nobidder"));
            bidInfo.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.auction.minbid", (Object[])new Object[]{this.lastBidAmount.getString()}));
        } else {
            bidInfo.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.auction.lastbidder", (Object[])new Object[]{this.lastBidPlayer.getName(true)}));
            bidInfo.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.auction.currentbid", (Object[])new Object[]{this.lastBidAmount.getString()}));
            bidInfo.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.auction.minbid", (Object[])new Object[]{this.getMinNextBid().getString()}));
        }
        return bidInfo;
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            class_1799 item = this.auctionItems.get(i);
            if (item.method_7960()) continue;
            entries.add(DisplayEntry.of(item, item.method_7947(), ItemRenderUtil.getTooltipFromItem(item)));
        }
        return entries;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, class_1799 heldItem) {
        this.openCancelAuctionTab(tab, clientHandler);
    }

    private void openCancelAuctionTab(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler) {
        TraderData t = tab.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            int tradeIndex = trader.getTradeIndex(this);
            if (tradeIndex < 0) {
                return;
            }
            class_2487 extraData = new class_2487();
            extraData.method_10569("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderAdditional(class_339 button, class_332 gui, int mouseX, int mouseY, TradeContext context) {
        TimeUtil.TimeData time = new TimeUtil.TimeData(this.getRemainingTime(TimeUtil.getCurrentTime()));
        TextRenderUtil.drawCenteredText(gui, time.getShortString(1), button.method_46426() + button.method_25368() / 2, button.method_46427() + button.method_25364() - 9, this.getTextColor(time));
    }

    @Override
    public List<class_2561> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        TimeUtil.TimeData time = new TimeUtil.TimeData(this.getRemainingTime(TimeUtil.getCurrentTime()));
        return Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43469((String)"gui.lightmanscurrency.auction.time_remaining", (Object[])new Object[]{class_2561.method_43470((String)time.getString()).method_27694(s -> s.method_36139(this.getTextColor(time)))})});
    }

    private int getTextColor(TimeUtil.TimeData remainingTime) {
        if (remainingTime.miliseconds < 3600000L) {
            if (remainingTime.miliseconds < 300000L) {
                return 0xFF0000;
            }
            return 0xFFFF00;
        }
        return 65280;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.NONE;
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        return new TradeData.TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<class_2561> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        return new ArrayList<class_2561>();
    }
}

