/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;

public class PersistentAuctionData {
    public final String id;
    public final long duration;
    private final List<class_1799> items;
    private final CoinValue startBid;
    private final CoinValue minBid;

    public final List<class_1799> getAuctionItems() {
        ArrayList<class_1799> copy = new ArrayList<class_1799>();
        for (class_1799 stack : this.items) {
            copy.add(stack.method_7972());
        }
        return copy;
    }

    public final CoinValue getStartingBid() {
        return this.startBid.copy();
    }

    public final CoinValue getMinimumBidDifference() {
        return this.minBid;
    }

    private PersistentAuctionData(String id, long duration, List<class_1799> items, CoinValue startBid, CoinValue minBid) {
        this.id = id;
        this.duration = duration;
        this.items = items;
        this.startBid = startBid;
        this.minBid = minBid;
    }

    public AuctionTradeData createAuction() {
        return new AuctionTradeData(this);
    }

    public static PersistentAuctionData load(JsonObject json) throws Exception {
        String id;
        if (json.has("ID")) {
            id = json.get("ID").getAsString();
        } else if (json.has("id")) {
            id = json.get("id").getAsString();
        } else {
            throw new Exception("Auction was not given a valid 'ID' entry!");
        }
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (json.has("Item1")) {
            items.add(FileUtil.parseItemStack(json.getAsJsonObject("Item1")));
        }
        if (json.has("Item2")) {
            items.add(FileUtil.parseItemStack(json.getAsJsonObject("Item2")));
        }
        if (items.size() <= 0) {
            throw new Exception("Auction has no 'Item1' or 'Item2' entry!");
        }
        long duration = 0L;
        duration = json.has("Duration") ? Math.max(json.get("Duration").getAsLong(), AuctionTradeData.GetMinimumDuration()) : AuctionTradeData.GetDefaultDuration();
        if (!json.has("StartingBid")) {
            throw new Exception("Auction has no 'StartingBid' entry!");
        }
        CoinValue startingBid = CoinValue.Parse(json.get("StartingBid"));
        CoinValue minimumBid = new CoinValue(1L);
        if (json.has("MinimumBid")) {
            minimumBid = CoinValue.Parse(json.get("MinimumBid"));
        }
        return new PersistentAuctionData(id, duration, items, startingBid, minimumBid);
    }
}

