/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traderinterface;

import io.github.lightman314.lightmanscurrency.common.traderinterface.NetworkTraderReference;
import io.github.lightman314.lightmanscurrency.common.traders.ITradeSource;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class NetworkTradeReference
extends NetworkTraderReference {
    private Function<class_2487, TradeData> tradeDeserializer;
    private int tradeIndex = -1;
    private TradeData tradeData = null;

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public boolean hasTrade() {
        return this.tradeIndex >= 0 && this.tradeData != null;
    }

    public TradeData getLocalTrade() {
        return this.tradeData;
    }

    public void setTrade(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.tradeData = this.copyTrade(this.getTrueTrade());
        if (this.tradeData == null) {
            this.tradeIndex = -1;
        }
    }

    public void refreshTrade() {
        if (!this.hasTrade()) {
            return;
        }
        TradeData newTrade = this.copyTrade(this.getTrueTrade());
        if (newTrade != null) {
            this.tradeData = newTrade;
        }
    }

    public TradeData copyTrade(TradeData trade) {
        if (trade == null) {
            return null;
        }
        return this.tradeDeserializer.apply(trade.getAsNBT());
    }

    public NetworkTradeReference(Supplier<Boolean> clientCheck, Function<class_2487, TradeData> tradeDeserializer) {
        super(clientCheck);
        this.tradeDeserializer = tradeDeserializer;
    }

    public TradeData getTrueTrade() {
        if (this.tradeIndex < 0) {
            return null;
        }
        TraderData trader = this.getTrader();
        if (trader instanceof ITradeSource) {
            ITradeSource tradeSource = (ITradeSource)((Object)trader);
            return tradeSource.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public class_2487 save() {
        class_2487 compound = super.save();
        if (this.tradeData != null && this.tradeIndex >= 0) {
            compound.method_10569("TradeIndex", this.tradeIndex);
            compound.method_10566("Trade", (class_2520)this.tradeData.getAsNBT());
        }
        return compound;
    }

    @Override
    public void load(class_2487 compound) {
        super.load(compound);
        if (compound.method_10573("TradeIndex", 3)) {
            this.tradeIndex = compound.method_10550("TradeIndex");
        } else if (compound.method_10573("Trade", 10)) {
            this.tradeData = this.tradeDeserializer.apply(compound.method_10562("Trade"));
        }
    }
}

