/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import io.github.lightman314.lightmanscurrency.client.data.ClientTeamData;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageRemoveClientTeam;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientTeam;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientTeam;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TeamSaveData
extends class_18 {
    private long nextID = 0L;
    private final Map<Long, Team> teams = new HashMap<Long, Team>();

    private long getNextID() {
        long id = this.nextID++;
        this.method_80();
        return id;
    }

    private TeamSaveData() {
    }

    private TeamSaveData(class_2487 compound) {
        this.nextID = compound.method_10537("NextID");
        class_2499 teamList = compound.method_10554("Teams", 10);
        for (int i = 0; i < teamList.size(); ++i) {
            Team team = Team.load(teamList.method_10602(i));
            if (team == null) continue;
            this.teams.put(team.getID(), team);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10544("NextID", this.nextID);
        class_2499 teamList = new class_2499();
        this.teams.forEach((teamID, team) -> {
            if (team != null) {
                teamList.add((Object)team.save());
            }
        });
        compound.method_10566("Teams", (class_2520)teamList);
        return compound;
    }

    private static TeamSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (TeamSaveData)level.method_17983().method_17924(TeamSaveData::new, TeamSaveData::new, "lightmanscurrency_team_data");
        }
        return null;
    }

    public static List<Team> GetAllTeams(boolean isClient) {
        if (isClient) {
            return ClientTeamData.GetAllTeams();
        }
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null) {
            return new ArrayList<Team>(tsd.teams.values());
        }
        return new ArrayList<Team>();
    }

    public static Team GetTeam(boolean isClient, long teamID) {
        if (isClient) {
            return ClientTeamData.GetTeam(teamID);
        }
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null && tsd.teams.containsKey(teamID)) {
            return tsd.teams.get(teamID);
        }
        return null;
    }

    public static void MarkTeamDirty(long teamID) {
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null) {
            tsd.method_80();
            Team team = TeamSaveData.GetTeam(false, teamID);
            if (team != null) {
                class_2487 compound = team.save();
                new SMessageUpdateClientTeam(compound).sendToAll();
            }
        }
    }

    public static Team RegisterTeam(class_1657 owner, String teamName) {
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null) {
            long teamID = tsd.getNextID();
            Team newTeam = Team.of(teamID, PlayerReference.of(owner), teamName);
            tsd.teams.put(teamID, newTeam);
            TeamSaveData.MarkTeamDirty(teamID);
            return newTeam;
        }
        return null;
    }

    public static void RemoveTeam(long teamID) {
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null && tsd.teams.containsKey(teamID)) {
            tsd.teams.remove(teamID);
            tsd.method_80();
            new SMessageRemoveClientTeam(teamID).sendToAll();
        }
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        TeamSaveData tsd = TeamSaveData.get();
        if (tsd != null) {
            class_2487 compound = new class_2487();
            class_2499 teamList = new class_2499();
            tsd.teams.forEach((id, team) -> teamList.add((Object)team.save()));
            compound.method_10566("Teams", (class_2520)teamList);
            new SMessageSetupClientTeam(compound).sendTo(sender);
        }
    }
}

