/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class ChangeSettingNotification
extends Notification {
    public static final class_2960 ADVANCED_TYPE = new class_2960("lightmanscurrency", "change_settings_advanced");
    public static final class_2960 SIMPLE_TYPE = new class_2960("lightmanscurrency", "change_settings_simple");
    protected PlayerReference player;
    protected String setting;

    protected ChangeSettingNotification(PlayerReference player, String setting) {
        this.player = player;
        this.setting = setting;
    }

    protected ChangeSettingNotification() {
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("Player", (class_2520)this.player.save());
        compound.method_10582("Setting", this.setting);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.player = PlayerReference.load(compound.method_10562("Player"));
        this.setting = compound.method_10558("Setting");
    }

    public static class Simple
    extends ChangeSettingNotification {
        String newValue;

        public Simple(PlayerReference player, String setting, String newValue) {
            super(player, setting);
            this.newValue = newValue;
        }

        public Simple(class_2487 compound) {
            this.load(compound);
        }

        @Override
        protected class_2960 getType() {
            return SIMPLE_TYPE;
        }

        @Override
        public class_5250 getMessage() {
            return class_2561.method_43469((String)"log.settings.change.simple", (Object[])new Object[]{this.player.getName(true), this.setting, this.newValue});
        }

        @Override
        protected void saveAdditional(class_2487 compound) {
            super.saveAdditional(compound);
            compound.method_10582("NewValue", this.newValue);
        }

        @Override
        protected void loadAdditional(class_2487 compound) {
            super.loadAdditional(compound);
            this.newValue = compound.method_10558("NewValue");
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Simple) {
                Simple n = (Simple)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue);
            }
            return false;
        }
    }

    public static class Advanced
    extends ChangeSettingNotification {
        String newValue;
        String oldValue;

        public Advanced(PlayerReference player, String setting, String newValue, String oldValue) {
            super(player, setting);
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Advanced(class_2487 compound) {
            this.load(compound);
        }

        @Override
        protected class_2960 getType() {
            return ADVANCED_TYPE;
        }

        @Override
        public class_5250 getMessage() {
            return class_2561.method_43469((String)"log.settings.change", (Object[])new Object[]{this.player.getName(true), this.setting, this.oldValue, this.newValue});
        }

        @Override
        protected void saveAdditional(class_2487 compound) {
            super.saveAdditional(compound);
            compound.method_10582("NewValue", this.newValue);
            compound.method_10582("OldValue", this.oldValue);
        }

        @Override
        protected void loadAdditional(class_2487 compound) {
            super.loadAdditional(compound);
            this.newValue = compound.method_10558("NewValue");
            this.oldValue = compound.method_10558("OldValue");
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Advanced) {
                Advanced n = (Advanced)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue) && n.oldValue.equals(this.oldValue);
            }
            return false;
        }
    }
}

