/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ChangeOwnerNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "change_ownership");
    PlayerReference player;
    OwnershipData newOwner;
    OwnershipData oldOwner;

    public ChangeOwnerNotification(class_2487 compound) {
        this.load(compound);
    }

    public ChangeOwnerNotification(PlayerReference player, PlayerReference newOwner, PlayerReference oldOwner) {
        this(player, OwnershipData.of(newOwner), OwnershipData.of(oldOwner));
    }

    public ChangeOwnerNotification(PlayerReference player, PlayerReference newOwner, Team oldOwner) {
        this(player, OwnershipData.of(newOwner), OwnershipData.of(oldOwner));
    }

    public ChangeOwnerNotification(PlayerReference player, Team newOwner, PlayerReference oldOwner) {
        this(player, OwnershipData.of(newOwner), OwnershipData.of(oldOwner));
    }

    public ChangeOwnerNotification(PlayerReference player, Team newOwner, Team oldOwner) {
        this(player, OwnershipData.of(newOwner), OwnershipData.of(oldOwner));
    }

    private ChangeOwnerNotification(PlayerReference player, OwnershipData newOwner, OwnershipData oldOwner) {
        this.player = player;
        this.newOwner = newOwner;
        this.oldOwner = oldOwner;
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    public class_5250 getMessage() {
        if (this.newOwner.is(this.player)) {
            return class_2561.method_43469((String)"log.settings.newowner.taken", (Object[])new Object[]{this.player.getName(true), this.oldOwner.getName()});
        }
        if (this.oldOwner.is(this.player)) {
            return class_2561.method_43469((String)"log.settings.newowner.passed", (Object[])new Object[]{this.player.getName(true), this.newOwner.getName()});
        }
        return class_2561.method_43469((String)"log.settings.newowner.transferred", (Object[])new Object[]{this.player.getName(true), this.oldOwner.getName(), this.newOwner.getName()});
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("Player", (class_2520)this.player.save());
        compound.method_10566("NewOwner", (class_2520)this.newOwner.save());
        compound.method_10566("OldOwner", (class_2520)this.oldOwner.save());
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.player = PlayerReference.load(compound.method_10562("Player"));
        this.newOwner = OwnershipData.load(compound.method_10562("NewOwner"));
        this.oldOwner = OwnershipData.load(compound.method_10562("OldOwner"));
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ChangeOwnerNotification) {
            ChangeOwnerNotification n = (ChangeOwnerNotification)other;
            return n.player.is(this.player) && n.newOwner.is(this.newOwner) && n.oldOwner.is(this.oldOwner);
        }
        return false;
    }

    private static class OwnershipData {
        public final PlayerReference player;
        public final long team;

        private OwnershipData(PlayerReference player, long team) {
            this.player = player;
            this.team = team;
        }

        public String getName() {
            if (this.player != null) {
                return this.player.getName(true);
            }
            Team team = TeamSaveData.GetTeam(true, this.team);
            if (team != null) {
                return team.getName();
            }
            return "DELETED TEAM";
        }

        public class_2487 save() {
            class_2487 compound = new class_2487();
            if (this.player != null) {
                compound.method_10566("Player", (class_2520)this.player.save());
            } else {
                compound.method_10544("Team", this.team);
            }
            return compound;
        }

        public boolean is(PlayerReference player) {
            if (this.player != null) {
                return this.player.is(player);
            }
            return false;
        }

        public boolean is(OwnershipData other) {
            if (this.player != null) {
                if (other.player != null) {
                    return this.player.is(other.player);
                }
                return false;
            }
            if (other.player != null) {
                return false;
            }
            return this.team == other.team;
        }

        public static OwnershipData of(PlayerReference player) {
            return new OwnershipData(player, -1L);
        }

        public static OwnershipData of(Team team) {
            return new OwnershipData(null, team.getID());
        }

        public static OwnershipData of(long teamID) {
            return new OwnershipData(null, teamID);
        }

        public static OwnershipData load(class_2487 compound) {
            if (compound.method_10545("Player")) {
                return OwnershipData.of(PlayerReference.load(compound.method_10562("Player")));
            }
            return OwnershipData.of(compound.method_10537("Team"));
        }
    }
}

