/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.item.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SlotMachineTradeNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "slot_machine_trade");
    TraderCategory traderData;
    List<ItemTradeNotification.ItemData> items;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    CoinValue money = new CoinValue(new CoinValue.CoinValuePair[0]);
    String customer;

    public SlotMachineTradeNotification(class_2487 tag) {
        this.load(tag);
    }

    protected SlotMachineTradeNotification(SlotMachineEntry entry, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        this.traderData = traderData;
        this.cost = cost.copy();
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        if (entry.isMoney()) {
            this.money = entry.getMoneyValue();
        } else {
            for (class_1799 item : InventoryUtil.combineQueryItems(entry.items)) {
                this.items.add(new ItemTradeNotification.ItemData(item));
            }
        }
        this.customer = customer.getName(false);
    }

    public static Supplier<Notification> create(SlotMachineEntry entry, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        return () -> new SlotMachineTradeNotification(entry, cost, customer, traderData);
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public class_5250 getMessage() {
        Object rewardText = this.money.getRawValue() > 0L ? this.money.getComponent("0") : SlotMachineTradeNotification.getItemNames(this.items);
        return EasyText.translatable("notifications.message.slot_machine_trade", this.customer, this.cost.getString("0"), rewardText);
    }

    public static class_2561 getItemNames(List<ItemTradeNotification.ItemData> items) {
        class_5250 result = null;
        for (ItemTradeNotification.ItemData item : items) {
            if (result != null) {
                result = item.formatWith((class_2561)result);
                continue;
            }
            result = item.format();
        }
        return result == null ? EasyText.literal("ERROR") : result;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("TraderInfo", (class_2520)this.traderData.save());
        class_2499 itemList = new class_2499();
        for (ItemTradeNotification.ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.method_10566("Items", (class_2520)itemList);
        this.money.save(compound, "Money");
        this.cost.save(compound, "Price");
        compound.method_10582("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.traderData = new TraderCategory(compound.method_10562("TraderInfo"));
        class_2499 itemList = compound.method_10554("Items", 10);
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemTradeNotification.ItemData(itemList.method_10602(i)));
        }
        this.money = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.money.load(compound, "Money");
        this.cost = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.cost.load(compound, "Price");
        this.customer = compound.method_10558("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof SlotMachineTradeNotification) {
            SlotMachineTradeNotification smtn = (SlotMachineTradeNotification)other;
            if (!smtn.traderData.matches(this.traderData)) {
                return false;
            }
            if (smtn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                ItemTradeNotification.ItemData i2;
                ItemTradeNotification.ItemData i1 = this.items.get(i);
                if (i1.matches(i2 = smtn.items.get(i))) continue;
                return false;
            }
            if (!smtn.money.equals(this.money)) {
                return false;
            }
            if (!smtn.cost.equals(this.cost)) {
                return false;
            }
            return smtn.customer.equals(this.customer);
        }
        return false;
    }
}

