/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class DepositWithdrawNotification
extends Notification {
    public static final class_2960 PLAYER_TYPE = new class_2960("lightmanscurrency", "bank_deposit_player");
    public static final class_2960 TRADER_TYPE = new class_2960("lightmanscurrency", "bank_deposit_trader");
    public static final class_2960 SERVER_TYPE = new class_2960("lightmanscurrency", "bank_deposit_server");
    protected class_5250 accountName;
    protected boolean isDeposit;
    protected CoinValue amount = new CoinValue(new CoinValue.CoinValuePair[0]);

    protected DepositWithdrawNotification(class_5250 accountName, boolean isDeposit, CoinValue amount) {
        this.accountName = accountName;
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    protected DepositWithdrawNotification() {
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.accountName));
        compound.method_10556("Deposit", this.isDeposit);
        this.amount.save(compound, "Amount");
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.accountName = class_2561.class_2562.method_10877((String)compound.method_10558("Name"));
        this.isDeposit = compound.method_10577("Deposit");
        this.amount.load(compound, "Amount");
    }

    protected abstract class_5250 getName();

    @Override
    public class_5250 getMessage() {
        return class_2561.method_43469((String)"log.bank", (Object[])new Object[]{this.getName(), class_2561.method_43471((String)(this.isDeposit ? "log.bank.deposit" : "log.bank.withdraw")), this.amount.getComponent()});
    }

    public static class Server
    extends DepositWithdrawNotification {
        public Server(class_5250 accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
        }

        public Server(class_2487 tag) {
            this.load(tag);
        }

        @Override
        protected class_5250 getName() {
            return EasyText.translatable("notifications.bank.server", new Object[0]);
        }

        @Override
        protected class_2960 getType() {
            return SERVER_TYPE;
        }

        @Override
        protected boolean canMerge(@NotNull Notification other) {
            return false;
        }
    }

    public static class Trader
    extends DepositWithdrawNotification {
        class_5250 traderName;

        public Trader(class_5250 traderName, class_5250 accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
            this.traderName = traderName;
        }

        public Trader(class_2487 compound) {
            this.load(compound);
        }

        @Override
        protected class_5250 getName() {
            return this.traderName;
        }

        @Override
        protected class_2960 getType() {
            return TRADER_TYPE;
        }

        @Override
        protected void saveAdditional(class_2487 compound) {
            super.saveAdditional(compound);
            compound.method_10582("Trader", class_2561.class_2562.method_10867((class_2561)this.traderName));
        }

        @Override
        protected void loadAdditional(class_2487 compound) {
            super.loadAdditional(compound);
            this.traderName = class_2561.class_2562.method_10877((String)compound.method_10558("Trader"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Trader) {
                Trader n = (Trader)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.traderName.equals((Object)this.traderName);
            }
            return false;
        }
    }

    public static class Player
    extends DepositWithdrawNotification {
        PlayerReference player;

        public Player(PlayerReference player, class_5250 accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
            this.player = player;
        }

        public Player(class_2487 compound) {
            this.load(compound);
        }

        @Override
        protected class_5250 getName() {
            return this.player.getNameComponent(true);
        }

        @Override
        protected class_2960 getType() {
            return PLAYER_TYPE;
        }

        @Override
        protected void saveAdditional(class_2487 compound) {
            super.saveAdditional(compound);
            compound.method_10566("Player", (class_2520)this.player.save());
        }

        @Override
        protected void loadAdditional(class_2487 compound) {
            super.loadAdditional(compound);
            this.player = PlayerReference.load(compound.method_10562("Player"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Player) {
                Player n = (Player)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.player.is(this.player);
            }
            return false;
        }
    }
}

