/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.events;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import java.util.UUID;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import org.jetbrains.annotations.NotNull;

public class NotificationEvent {
    public static final Event<NotificationPreSendCallback> PRE_SEND_EVENT = EventFactory.createArrayBacked(NotificationPreSendCallback.class, listeners -> preSendEvent -> {
        for (NotificationPreSendCallback listener : listeners) {
            if (listener.allow(preSendEvent)) continue;
            return false;
        }
        return true;
    });
    public static final Event<NotificationSentCallback> NOTIFICATION_SENT_EVENT = EventFactory.createArrayBacked(NotificationSentCallback.class, listeners -> notificationSentEvent -> {
        for (NotificationSentCallback listener : listeners) {
            listener.listen(notificationSentEvent);
        }
    });
    public static final Event<ClientNotificationCallback> CLIENT_NOTIFICATION_EVENT = EventFactory.createArrayBacked(ClientNotificationCallback.class, listeners -> clientNotificationEvent -> {
        for (ClientNotificationCallback listener : listeners) {
            if (listener.display(clientNotificationEvent)) continue;
            return false;
        }
        return true;
    });
    private final UUID playerID;
    private final NotificationData data;
    protected Notification notification;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public NotificationData getData() {
        return this.data;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public NotificationEvent(UUID playerID, NotificationData data, Notification notification) {
        this.playerID = playerID;
        this.data = data;
        this.notification = notification;
    }

    public static interface ClientNotificationCallback {
        public boolean display(NotificationReceivedOnClient var1);
    }

    public static class NotificationReceivedOnClient
    extends NotificationEvent {
        public NotificationReceivedOnClient(UUID playerID, NotificationData data, Notification notification) {
            super(playerID, data, notification);
        }
    }

    public static interface NotificationSentCallback {
        public void listen(NotificationSent.Post var1);
    }

    public static class NotificationSent
    extends NotificationEvent {
        protected NotificationSent(UUID playerID, NotificationData data, Notification notification) {
            super(playerID, data, notification);
        }

        public static class Post
        extends NotificationSent {
            public Post(UUID playerID, NotificationData data, Notification notification) {
                super(playerID, data, notification);
            }
        }

        public static class Pre
        extends NotificationSent {
            public Pre(UUID playerID, NotificationData data, Notification notification) {
                super(playerID, data, notification);
            }

            public void setNotification(@NotNull Notification notification) {
                if (notification == null) {
                    throw new NullPointerException("Cannot set the notification to null. Cancel the event if you wish for no notification to be sent.");
                }
                this.notification = notification;
            }
        }
    }

    public static interface NotificationPreSendCallback {
        public boolean allow(NotificationSent.Pre var1);
    }
}

