/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NotificationData {
    List<Notification> notifications = new ArrayList<Notification>();

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public List<Notification> getNotifications(NotificationCategory category) {
        if (category == NotificationCategory.GENERAL) {
            return this.notifications;
        }
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification not : this.notifications) {
            if (!category.matches(not.getCategory())) continue;
            result.add(not);
        }
        return result;
    }

    public boolean unseenNotification() {
        return this.unseenNotification(NotificationCategory.GENERAL);
    }

    public boolean unseenNotification(NotificationCategory category) {
        for (Notification n : this.getNotifications(category)) {
            if (n.wasSeen()) continue;
            return true;
        }
        return false;
    }

    public List<NotificationCategory> getCategories() {
        ArrayList<NotificationCategory> result = new ArrayList<NotificationCategory>();
        for (Notification not : this.notifications) {
            NotificationCategory category = not.getCategory();
            if (category == null || !result.stream().noneMatch(cat -> cat.matches(category))) continue;
            result.add(category);
        }
        return result;
    }

    public void addNotification(Notification newNotification) {
        Notification mostRecent;
        boolean shouldAdd = true;
        if (this.notifications.size() > 0 && (mostRecent = this.notifications.get(0)).onNewNotification(newNotification)) {
            shouldAdd = false;
        }
        if (shouldAdd) {
            this.notifications.add(0, newNotification);
        }
        this.validateListSize();
    }

    private void validateListSize() {
        int limit = (Integer)LCConfig.SERVER.notificationLimit.get();
        while (this.notifications.size() > limit) {
            this.notifications.remove(this.notifications.get(this.notifications.size() - 1));
        }
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        class_2499 notificationList = new class_2499();
        for (int i = 0; i < this.notifications.size(); ++i) {
            notificationList.add((Object)this.notifications.get(i).save());
        }
        compound.method_10566("Notifications", (class_2520)notificationList);
        return compound;
    }

    public static NotificationData loadFrom(class_2487 compound) {
        NotificationData data = new NotificationData();
        data.load(compound);
        return data;
    }

    public void load(class_2487 compound) {
        if (compound.method_10573("Notifications", 9)) {
            this.notifications = new ArrayList<Notification>();
            class_2499 notificationList = compound.method_10554("Notifications", 10);
            for (int i = 0; i < notificationList.size(); ++i) {
                class_2487 notTag = notificationList.method_10602(i);
                Notification not = Notification.deserialize(notTag);
                if (not == null) continue;
                this.notifications.add(not);
            }
            this.validateListSize();
        }
    }
}

