/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class Notification {
    private static final Map<String, Function<class_2487, Notification>> DESERIALIZERS = new HashMap<String, Function<class_2487, Notification>>();
    private boolean seen = false;
    private int count = 1;

    public static void register(class_2960 type, Supplier<Notification> deserializer) {
        Notification.register(type, (class_2487 c) -> {
            Notification n = (Notification)deserializer.get();
            n.load((class_2487)c);
            return n;
        });
    }

    public static void register(class_2960 type, Function<class_2487, Notification> deserializer) {
        String t = type.toString();
        if (DESERIALIZERS.containsKey(t)) {
            LightmansCurrency.LogError("Notification of type " + t + " is already registered.");
            return;
        }
        if (deserializer == null) {
            LightmansCurrency.LogError("Deserializer of notification type " + t + " is null. Unable to register.");
            return;
        }
        DESERIALIZERS.put(t, deserializer);
    }

    public static Notification deserialize(class_2487 compound) {
        if (compound.method_10545("Type") || compound.method_10545("type")) {
            String type;
            String string = type = compound.method_10545("Type") ? compound.method_10558("Type") : compound.method_10558("type");
            if (DESERIALIZERS.containsKey(type)) {
                return DESERIALIZERS.get(type).apply(compound);
            }
            LightmansCurrency.LogError("Cannot deserialize notification type " + type + " as no deserializer has been registered.");
            return null;
        }
        LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag.");
        return null;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected abstract class_2960 getType();

    public abstract NotificationCategory getCategory();

    public abstract class_5250 getMessage();

    public class_5250 getGeneralMessage() {
        return class_2561.method_43469((String)"notifications.source.general.format", (Object[])new Object[]{this.getCategory().getName(), this.getMessage()});
    }

    public class_5250 getChatMessage() {
        return class_2561.method_43469((String)"notifications.chat.format", (Object[])new Object[]{class_2561.method_43469((String)"notifications.chat.format.title", (Object[])new Object[]{this.getCategory().getName()}).method_27692(class_124.field_1065), this.getMessage()});
    }

    public final class_2487 save() {
        class_2487 compound = new class_2487();
        if (this.seen) {
            compound.method_10556("Seen", true);
        }
        compound.method_10569("Count", this.count);
        compound.method_10582("Type", this.getType().toString());
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(class_2487 var1);

    public final void load(class_2487 compound) {
        if (compound.method_10545("Seen")) {
            this.seen = true;
        }
        if (compound.method_10573("Count", 3)) {
            this.count = compound.method_10550("Count");
        }
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(class_2487 var1);

    public boolean onNewNotification(Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(Notification var1);
}

