/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.bank;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.data.ClientBankData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientBank;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSyncSelectedBankAccount;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSelectBankAccount;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BankSaveData
extends class_18 {
    private final Map<UUID, Pair<BankAccount, BankAccount.AccountReference>> playerBankData = new HashMap<UUID, Pair<BankAccount, BankAccount.AccountReference>>();

    private BankSaveData() {
    }

    private BankSaveData(class_2487 compound) {
        class_2499 bankData = compound.method_10554("PlayerBankData", 10);
        for (int i = 0; i < bankData.size(); ++i) {
            class_2487 tag = bankData.method_10602(i);
            UUID player = tag.method_25926("Player");
            BankAccount bankAccount = BankSaveData.loadBankAccount(player, tag.method_10562("BankAccount"));
            BankAccount.AccountReference lastSelected = BankAccount.LoadReference(false, tag.method_10562("LastSelected"));
            this.playerBankData.put(player, (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)bankAccount, (Object)lastSelected));
        }
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 bankData = new class_2499();
        this.playerBankData.forEach((player, data) -> {
            class_2487 tag = new class_2487();
            tag.method_25927("Player", player);
            tag.method_10566("BankAccount", (class_2520)((BankAccount)data.getFirst()).save());
            tag.method_10566("LastSelected", (class_2520)((BankAccount.AccountReference)data.getSecond()).save());
            bankData.add((Object)tag);
        });
        compound.method_10566("PlayerBankData", (class_2520)bankData);
        return compound;
    }

    private static BankAccount loadBankAccount(UUID player, class_2487 compound) {
        BankAccount bankAccount = new BankAccount(() -> BankSaveData.MarkBankAccountDirty(player), compound);
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bankAccount;
    }

    private static BankAccount generateBankAccount(UUID player) {
        BankAccount bankAccount = new BankAccount(() -> BankSaveData.MarkBankAccountDirty(player));
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bankAccount;
    }

    private static BankSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (BankSaveData)level.method_17983().method_17924(BankSaveData::new, BankSaveData::new, "lightmanscurrency_bank_data");
        }
        return null;
    }

    public static List<BankAccount.AccountReference> GetPlayerBankAccounts() {
        ArrayList<BankAccount.AccountReference> results = new ArrayList<BankAccount.AccountReference>();
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            bsd.playerBankData.forEach((player, data) -> results.add(BankAccount.GenerateReference(false, player)));
        }
        return results;
    }

    public static BankAccount GetBankAccount(class_1657 player) {
        return BankSaveData.GetBankAccount(player.method_37908().field_9236, player.method_5667());
    }

    public static BankAccount GetBankAccount(boolean isClient, UUID player) {
        if (player == null) {
            return null;
        }
        if (isClient) {
            return ClientBankData.GetPlayerBankAccount(player);
        }
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            if (bsd.playerBankData.containsKey(player)) {
                return (BankAccount)bsd.playerBankData.get(player).getFirst();
            }
            BankAccount newAccount = BankSaveData.generateBankAccount(player);
            bsd.playerBankData.put(player, (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)newAccount, (Object)BankAccount.GenerateReference(false, player)));
            BankSaveData.MarkBankAccountDirty(player);
            return newAccount;
        }
        return null;
    }

    @Deprecated
    public static void GiveOldBankAccount(UUID player, BankAccount account) {
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            if (bsd.playerBankData.containsKey(player)) {
                bsd.playerBankData.put(player, (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)account, (Object)((BankAccount.AccountReference)bsd.playerBankData.get(player).getSecond())));
            } else {
                bsd.playerBankData.put(player, (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)account, (Object)BankAccount.GenerateReference(false, player)));
            }
        }
    }

    public static void MarkBankAccountDirty(UUID player) {
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            bsd.method_80();
            BankAccount bankAccount = BankSaveData.GetBankAccount(false, player);
            class_2487 compound = bankAccount.save();
            compound.method_25927("Player", player);
            new SMessageUpdateClientBank(compound).sendToAll();
        }
    }

    public static BankAccount.AccountReference GetSelectedBankAccount(class_1657 player) {
        if (player.method_37908().field_9236) {
            ClientBankData.GetLastSelectedAccount();
        } else {
            BankSaveData bsd = BankSaveData.get();
            if (bsd != null) {
                if (bsd.playerBankData.containsKey(player.method_5667())) {
                    BankAccount.AccountReference account = (BankAccount.AccountReference)bsd.playerBankData.get(player.method_5667()).getSecond();
                    if (!account.allowedAccess(player)) {
                        LightmansCurrency.LogInfo(player.method_5477().getString() + " is no longer allowed to access their selected bank account. Switching back to their personal account.");
                        account = BankAccount.GenerateReference(player);
                        BankSaveData.SetSelectedBankAccount(player, account);
                    }
                    return account;
                }
                BankAccount.AccountReference account = BankAccount.GenerateReference(player);
                BankSaveData.SetSelectedBankAccount(player, account);
                return account;
            }
        }
        return BankAccount.GenerateReference(player);
    }

    public static void SetSelectedBankAccount(class_1657 player, BankAccount.AccountReference account) {
        if (account == null) {
            return;
        }
        if (player.method_37908().field_9236) {
            new CMessageSelectBankAccount(account).sendToServer();
        } else {
            if (!account.allowedAccess(player)) {
                LightmansCurrency.LogDebug("Player does not have access to the selected account. Canceling selection.");
                return;
            }
            BankSaveData bsd = BankSaveData.get();
            if (bsd != null) {
                if (bsd.playerBankData.containsKey(player.method_5667())) {
                    bsd.playerBankData.put(player.method_5667(), (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)((BankAccount)bsd.playerBankData.get(player.method_5667()).getFirst()), (Object)account));
                } else {
                    bsd.playerBankData.put(player.method_5667(), (Pair<BankAccount, BankAccount.AccountReference>)Pair.of((Object)BankSaveData.generateBankAccount(player.method_5667()), (Object)account));
                    BankSaveData.MarkBankAccountDirty(player.method_5667());
                }
                bsd.method_80();
                new SMessageSyncSelectedBankAccount(account).sendTo(player);
            }
        }
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        BankSaveData bsd = BankSaveData.get();
        if (bsd != null) {
            BankSaveData.GetBankAccount((class_1657)player);
            class_2487 compound = new class_2487();
            class_2499 bankList = new class_2499();
            bsd.playerBankData.forEach((id, data) -> {
                class_2487 tag = ((BankAccount)data.getFirst()).save();
                tag.method_25927("Player", id);
                bankList.add((Object)tag);
            });
            compound.method_10566("BankAccounts", (class_2520)bankList);
            new SMessageSetupClientBank(compound).sendTo(sender);
            BankAccount.AccountReference selectedAccount = BankSaveData.GetSelectedBankAccount((class_1657)player);
            new SMessageSyncSelectedBankAccount(selectedAccount).sendTo(sender);
        }
    }
}

