/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyData;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoneyUtil {
    public static final String MONEY_FILE_LOCATION = "config/lightmanscurrency/MasterCoinList.json";
    public static final String MAIN_CHAIN = "main";
    private static MoneyData moneyData = null;

    public static MoneyData getMoneyData() {
        if (moneyData == null) {
            MoneyUtil.reloadMoneyData();
        }
        return moneyData;
    }

    public static void receiveMoneyData(MoneyData data) {
        moneyData = data;
    }

    public static class_5250 getPluralName(class_1792 coin) {
        if (moneyData != null) {
            return moneyData.getPluralName(coin);
        }
        return MoneyUtil.getDefaultPlural(coin);
    }

    public static class_5250 getDefaultPlural(class_1792 coin) {
        String defaultPlural = coin.method_7876() + ".plural";
        if (class_2561.method_43471((String)defaultPlural).getString().equals(defaultPlural)) {
            return class_2561.method_43469((String)"item.lightmanscurrency.generic.plural", (Object[])new Object[]{coin.method_7864(new class_1799((class_1935)coin))});
        }
        return class_2561.method_43471((String)defaultPlural);
    }

    public static void reloadMoneyData() {
        LightmansCurrency.LogInfo("Reloading Money Data");
        File mcl = new File(MONEY_FILE_LOCATION);
        if (!mcl.exists()) {
            MoneyUtil.createMoneyDataFile(mcl);
        }
        try {
            JsonObject fileData = class_3518.method_15285((String)Files.readString(mcl.toPath()));
            moneyData = MoneyData.fromJson(fileData);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Master Coin List. Using default values for now.", e);
            moneyData = MoneyData.generateDefault();
        }
        moneyData.sendTo(ServerHook.getServer().method_3760().method_14571());
    }

    private static void createMoneyDataFile(File mcl) {
        File dir = new File(mcl.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                MoneyData defaultData = MoneyData.generateDefault();
                mcl.createNewFile();
                FileUtil.writeStringToFile(mcl, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)defaultData.toJson()));
                LightmansCurrency.LogInfo("MasterCoinList.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'MasterCoinList.json' file.", e);
            }
        }
    }

    public static void onPlayerLogin(class_3222 player, PacketSender sender) {
        moneyData.sendTo(sender);
    }

    public static void initializeDefaultCoins(MoneyData.CoinDataCollector dataCollector) {
        LightmansCurrency.LogInfo("Generating default coin values.");
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_COPPER, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_copper.initial").definePluralForm("item.lightmanscurrency.coin_copper.plural"));
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_IRON, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_iron.initial").definePluralForm("item.lightmanscurrency.coin_iron.plural").defineConversion((class_1935)ModItems.COIN_COPPER, 10));
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_GOLD, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_gold.initial").definePluralForm("item.lightmanscurrency.coin_gold.plural").defineConversion((class_1935)ModItems.COIN_IRON, 10));
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_EMERALD, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_emerald.initial").definePluralForm("item.lightmanscurrency.coin_emerald.plural").defineConversion((class_1935)ModItems.COIN_GOLD, 10));
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_DIAMOND, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_diamond.initial").definePluralForm("item.lightmanscurrency.coin_diamond.plural").defineConversion((class_1935)ModItems.COIN_EMERALD, 10));
        dataCollector.addCoinBuilder(CoinData.getBuilder((class_1935)ModItems.COIN_NETHERITE, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_netherite.initial").definePluralForm("item.lightmanscurrency.coin_netherite.plural").defineConversion((class_1935)ModItems.COIN_DIAMOND, 10));
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_COPPER, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_COPPER, 9).definePluralForm("block.lightmanscurrency.coinpile_copper.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_COPPER, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_COPPER, 4).definePluralForm("block.lightmanscurrency.coinblock_copper.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_IRON, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_IRON, 9).definePluralForm("block.lightmanscurrency.coinpile_iron.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_IRON, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_IRON, 4).definePluralForm("block.lightmanscurrency.coinblock_iron.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_GOLD, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_GOLD, 9).definePluralForm("block.lightmanscurrency.coinpile_gold.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_GOLD, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_GOLD, 4).definePluralForm("block.lightmanscurrency.coinblock_gold.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_EMERALD, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_EMERALD, 9).definePluralForm("block.lightmanscurrency.coinpile_emerald.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_EMERALD, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_EMERALD, 4).definePluralForm("block.lightmanscurrency.coinblock_emerald.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_DIAMOND, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_DIAMOND, 9).definePluralForm("block.lightmanscurrency.coinpile_diamond.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_DIAMOND, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_DIAMOND, 4).definePluralForm("block.lightmanscurrency.coinblock_diamond.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_NETHERITE, MAIN_CHAIN).defineConversion((class_1935)ModItems.COIN_NETHERITE, 9).definePluralForm("block.lightmanscurrency.coinpile_netherite.plural").setHidden());
        dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_NETHERITE, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_NETHERITE, 4).definePluralForm("block.lightmanscurrency.coinblock_netherite.plural").setHidden());
    }

    public static boolean isCoin(class_1792 item) {
        return MoneyUtil.isCoin(item, true);
    }

    public static boolean isCoin(class_1792 item, boolean allowHidden) {
        if (item == null) {
            return false;
        }
        CoinData data = MoneyUtil.getData(item);
        if (data == null) {
            return false;
        }
        return allowHidden || !data.isHidden;
    }

    public static boolean isCoinHidden(class_1792 item) {
        if (item == null) {
            return false;
        }
        CoinData data = MoneyUtil.getData(item);
        if (data == null) {
            return false;
        }
        return data.isHidden;
    }

    public static boolean isVisibleCoin(class_1792 item) {
        return MoneyUtil.isCoin(item, false);
    }

    public static boolean isCoin(@NotNull class_1799 stack) {
        return MoneyUtil.isCoin(stack, true);
    }

    public static boolean isCoin(@NotNull class_1799 stack, boolean allowHidden) {
        return MoneyUtil.isCoin(stack.method_7909(), allowHidden);
    }

    public static long getValue(class_1792 coinItem) {
        CoinData coinData = MoneyUtil.getData(coinItem);
        if (coinData != null) {
            return coinData.getValue();
        }
        return 0L;
    }

    public static CoinValue getCoinValue(class_1799 coinStack) {
        return new CoinValue(MoneyUtil.getValue(coinStack));
    }

    public static long getValue(class_1799 coinStack) {
        return MoneyUtil.getValue(coinStack.method_7909()) * (long)coinStack.method_7947();
    }

    public static CoinValue getCoinValue(List<class_1799> inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static long getValue(List<class_1799> inventory) {
        long value = 0L;
        for (class_1799 itemStack : inventory) {
            value += MoneyUtil.getValue(itemStack);
        }
        return value;
    }

    public static CoinValue getCoinValue(class_1263 inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static long getValue(class_1263 inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            value += MoneyUtil.getValue(inventory.method_5438(i));
        }
        return value;
    }

    public static void ConvertAllCoinsUp(class_1263 inventory) {
        int i;
        if (moneyData == null) {
            return;
        }
        List<class_1792> coinList = MoneyUtil.getAllCoins(false);
        for (i = 1; i < coinList.size(); ++i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i));
        }
        for (i = coinList.size() - 1; i > 0; --i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i));
        }
    }

    public static class_2371<class_1799> ConvertAllCoinsUp(class_2371<class_1799> inventoryList) {
        class_1277 inventory = InventoryUtil.buildInventory(inventoryList);
        MoneyUtil.ConvertAllCoinsUp((class_1263)inventory);
        return InventoryUtil.buildList((class_1263)inventory);
    }

    public static void ConvertCoinsUp(class_1263 inventory, class_1792 smallCoin) {
        Pair<class_1792, Integer> upwardConversion = MoneyUtil.getUpwardConversion(smallCoin);
        if (upwardConversion == null) {
            return;
        }
        class_1792 largeCoin = (class_1792)upwardConversion.getFirst();
        int smallCoinCount = (Integer)upwardConversion.getSecond();
        if (!MoneyUtil.isCoin(largeCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, smallCoin) >= smallCoinCount) {
            InventoryUtil.RemoveItemCount(inventory, smallCoin, smallCoinCount);
            class_1799 newCoinStack = new class_1799((class_1935)largeCoin, 1);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new class_1799((class_1935)smallCoin, smallCoinCount));
            return;
        }
    }

    public static void ConvertAllCoinsDown(class_1263 inventory) {
        MoneyUtil.ConvertAllCoinsDown(inventory, 2);
    }

    private static void ConvertAllCoinsDown(class_1263 inventory, int iterations) {
        if (moneyData == null) {
            return;
        }
        List<CoinData> coinList = moneyData.getSortedCoinList();
        for (int x = 0; x < iterations; ++x) {
            for (int i = 0; i < coinList.size() - 1; ++i) {
                if (coinList.get((int)i).isHidden) continue;
                MoneyUtil.ConvertCoinsDown(inventory, coinList.get((int)i).coinItem);
            }
        }
    }

    public static void ConvertCoinsDown(class_1263 inventory, class_1792 largeCoin) {
        CoinData coinData = MoneyUtil.getData(largeCoin);
        if (coinData == null) {
            return;
        }
        class_1792 smallCoin = coinData.worthOtherCoin;
        int smallCoinCount = coinData.worthOtherCoinCount;
        if (!MoneyUtil.isCoin(smallCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, largeCoin) > 0) {
            InventoryUtil.RemoveItemCount(inventory, largeCoin, 1);
            class_1799 newCoinStack = new class_1799((class_1935)smallCoin, smallCoinCount);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new class_1799((class_1935)largeCoin, 1));
            return;
        }
    }

    public static void SortCoins(class_1263 inventory) {
        InventoryUtil.MergeStacks(inventory);
        ArrayList<class_1799> oldInventory = new ArrayList<class_1799>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            oldInventory.add(inventory.method_5438(i));
        }
        inventory.method_5448();
        int index = 0;
        while (oldInventory.size() > 0) {
            int highestIndex = 0;
            long highestIndividualValue = MoneyUtil.getValue(((class_1799)oldInventory.get(0)).method_7909());
            long highestWholeValue = highestIndividualValue * (long)((class_1799)oldInventory.get(0)).method_7947();
            for (int i = 1; i < oldInventory.size(); ++i) {
                class_1799 stack = (class_1799)oldInventory.get(i);
                long thisIndividualValue = MoneyUtil.getValue(stack.method_7909());
                long thisWholeValue = thisIndividualValue * (long)stack.method_7947();
                if (thisIndividualValue > highestIndividualValue) {
                    highestIndex = i;
                    highestIndividualValue = thisIndividualValue;
                    highestWholeValue = thisWholeValue;
                    continue;
                }
                if (thisIndividualValue != highestIndividualValue || thisWholeValue <= highestWholeValue) continue;
                highestIndex = i;
                highestWholeValue = thisWholeValue;
            }
            inventory.method_5447(index, (class_1799)oldInventory.get(highestIndex));
            ++index;
            oldInventory.remove(highestIndex);
        }
    }

    public static class_2371<class_1799> SortCoins(class_2371<class_1799> inventory) {
        class_1277 tempInventory = InventoryUtil.buildInventory(inventory);
        MoneyUtil.SortCoins((class_1263)tempInventory);
        return InventoryUtil.buildList((class_1263)tempInventory);
    }

    public static boolean ProcessPayment(@Nullable class_1263 inventory, @NotNull class_1657 player, @NotNull CoinValue price) {
        return MoneyUtil.ProcessPayment(inventory, player, price, false);
    }

    public static boolean ProcessPayment(@Nullable class_1263 inventory, @NotNull class_1657 player, @NotNull CoinValue price, boolean ignoreWallet) {
        class_1799 wallet = WalletHandler.getWallet(player).getWallet();
        long valueToTake = price.getRawValue();
        long rawInventoryValue = 0L;
        if (inventory != null) {
            rawInventoryValue += MoneyUtil.getValue(inventory);
        }
        if (!wallet.method_7960()) {
            rawInventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (rawInventoryValue < valueToTake) {
            return false;
        }
        if (inventory != null) {
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, inventory, true);
        }
        if (valueToTake > 0L && !wallet.method_7960()) {
            class_2371<class_1799> walletInventory = WalletItem.getWalletInventory(wallet);
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, walletInventory);
            WalletItem.putWalletInventory(wallet, walletInventory);
        }
        if (valueToTake < 0L) {
            List<class_1799> change = MoneyUtil.getCoinsOfValue(Math.abs(valueToTake));
            for (class_1799 coinStack : change) {
                if (!wallet.method_7960()) {
                    coinStack = WalletItem.PickupCoin(wallet, coinStack);
                }
                if (!coinStack.method_7960() && inventory != null) {
                    coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
                }
                if (coinStack.method_7960()) continue;
                InventoryUtil.GiveToPlayer(player, coinStack);
            }
        }
        return true;
    }

    public static void ProcessChange(@Nullable class_1263 inventory, @NotNull class_1657 player, @NotNull CoinValue change) {
        MoneyUtil.ProcessChange(inventory, player, change, false);
    }

    public static void ProcessChange(@Nullable class_1263 inventory, @NotNull class_1657 player, @NotNull CoinValue change, boolean ignoreWallet) {
        class_1799 wallet = WalletHandler.getWallet(player).getWallet();
        List<class_1799> changeCoins = MoneyUtil.getCoinsOfValue(change);
        for (class_1799 coinStack : changeCoins) {
            if (!wallet.method_7960()) {
                coinStack = WalletItem.PickupCoin(wallet, coinStack);
            }
            if (!coinStack.method_7960() && inventory != null) {
                coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
            }
            if (coinStack.method_7960()) continue;
            player.method_31548().method_7394(coinStack);
        }
    }

    public static long takeObjectsOfValue(long value, class_1263 inventory, boolean forceTake) {
        class_1799 itemStack;
        int i;
        long coinValue;
        if (moneyData == null) {
            return value;
        }
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        List<CoinData> coinList = moneyData.getSortedCoinList();
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.method_5439() && coinValue <= value; ++i) {
                itemStack = inventory.method_5438(i);
                if (!inventory.method_5438(i).method_7909().equals(coinData.coinItem)) continue;
                while (coinValue <= value && !itemStack.method_7960()) {
                    value -= coinValue;
                    itemStack.method_7939(itemStack.method_7947() - 1);
                    if (!itemStack.method_7960()) continue;
                    inventory.method_5447(i, class_1799.field_8037);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                class_1792 coin = coinList.get((int)c).coinItem;
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.method_5439() && value > 0L; ++i) {
                    itemStack = inventory.method_5438(i);
                    if (itemStack.method_7909() != coin) continue;
                    while (value > 0L && !itemStack.method_7960()) {
                        value -= coinValue;
                        itemStack.method_7939(itemStack.method_7947() - 1);
                        if (!itemStack.method_7960()) continue;
                        inventory.method_5447(i, class_1799.field_8037);
                    }
                }
            }
        }
        return value;
    }

    private static long takeObjectsOfValue(long value, class_2371<class_1799> inventory) {
        return MoneyUtil.takeObjectsOfValue(value, inventory, false);
    }

    public static long takeObjectsOfValue(long value, class_2371<class_1799> inventory, boolean forceTake) {
        class_1799 itemStack;
        int i;
        long coinValue;
        if (moneyData == null) {
            return value;
        }
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        List<CoinData> coinList = moneyData.getSortedCoinList();
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.size() && coinValue <= value; ++i) {
                itemStack = (class_1799)inventory.get(i);
                if (!((class_1799)inventory.get(i)).method_7909().equals(coinData.coinItem)) continue;
                while (coinValue <= value && !itemStack.method_7960()) {
                    value -= coinValue;
                    itemStack.method_7939(itemStack.method_7947() - 1);
                    if (!itemStack.method_7960()) continue;
                    inventory.set(i, (Object)class_1799.field_8037);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                class_1792 coin = coinList.get((int)c).coinItem;
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.size() && value > 0L; ++i) {
                    itemStack = (class_1799)inventory.get(i);
                    if (itemStack.method_7909() != coin) continue;
                    while (value > 0L && !itemStack.method_7960()) {
                        value -= coinValue;
                        itemStack.method_7939(itemStack.method_7947() - 1);
                        if (!itemStack.method_7960()) continue;
                        inventory.set(i, (Object)class_1799.field_8037);
                    }
                }
            }
        }
        return value;
    }

    public static List<class_1799> getCoinsOfValue(long value) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (value <= 0L || moneyData == null) {
            return items;
        }
        List<CoinData> coinList = moneyData.getSortedCoinList(MAIN_CHAIN);
        for (CoinData coinData : coinList) {
            if (coinData.isHidden) continue;
            class_1792 coin = coinData.coinItem;
            int coinsToGive = 0;
            long coinValue = coinData.getValue();
            while (coinValue <= value) {
                value -= coinValue;
                ++coinsToGive;
            }
            while (coinsToGive > 0) {
                int giveCount = coinsToGive;
                class_1799 newStack = new class_1799((class_1935)coin);
                if (giveCount > newStack.method_7914()) {
                    giveCount = newStack.method_7914();
                }
                coinsToGive -= giveCount;
                newStack.method_7939(giveCount);
                items.add(newStack);
            }
        }
        return items;
    }

    public static List<class_1799> getCoinsOfValue(CoinValue value) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (CoinValue.CoinValuePair pricePair : value.coinValues) {
            int amountToAdd;
            for (int amount = pricePair.amount; amount > 0; amount -= amountToAdd) {
                class_1799 newStack = new class_1799((class_1935)pricePair.coin);
                amountToAdd = MathUtil.clamp(amount, 0, newStack.method_7914());
                newStack.method_7939(amountToAdd);
                items.add(newStack);
            }
        }
        return items;
    }

    public static String getStringOfValue(long value) {
        return new CoinValue(value).getString();
    }

    public static CoinData getData(class_1792 coinItem) {
        if (moneyData == null) {
            return null;
        }
        return moneyData.getData(coinItem);
    }

    public static List<class_1792> getAllCoins() {
        return MoneyUtil.getAllCoins(false);
    }

    public static List<class_1792> getAllCoins(boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<class_1792>();
        }
        ArrayList<class_1792> coinItems = new ArrayList<class_1792>();
        List<CoinData> coinList = moneyData.getSortedCoinList();
        for (CoinData coinData : coinList) {
            if (coinData.isHidden && !includeHidden) continue;
            coinItems.add(coinData.coinItem);
        }
        return coinItems;
    }

    public static List<class_1792> getAllCoins(String chain) {
        return MoneyUtil.getAllCoins(chain, false);
    }

    public static List<class_1792> getAllCoins(String chain, boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<class_1792>();
        }
        ArrayList<class_1792> coinItems = new ArrayList<class_1792>();
        List<CoinData> coinList = moneyData.getSortedCoinList();
        for (CoinData coinData : coinList) {
            if (!coinData.chain.contentEquals(chain) || coinData.isHidden && !includeHidden) continue;
            coinItems.add(coinData.coinItem);
        }
        return coinItems;
    }

    public static List<CoinData> getAllData() {
        return MoneyUtil.getAllData(false);
    }

    public static List<CoinData> getAllData(boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<CoinData>();
        }
        List<CoinData> coinList = moneyData.getSortedCoinList();
        if (includeHidden) {
            return coinList;
        }
        ArrayList<CoinData> publicCoinList = new ArrayList<CoinData>();
        for (CoinData coinData : coinList) {
            if (coinData.isHidden) continue;
            publicCoinList.add(coinData);
        }
        return publicCoinList;
    }

    public static List<CoinData> getAllData(String chain) {
        return MoneyUtil.getAllData(chain, false);
    }

    public static List<CoinData> getAllData(String chain, boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<CoinData>();
        }
        List<CoinData> coinList = moneyData.getSortedCoinList(chain);
        if (includeHidden) {
            return coinList;
        }
        ArrayList<CoinData> publicCoinList = new ArrayList<CoinData>();
        for (CoinData coinData : coinList) {
            if (coinData.isHidden) continue;
            publicCoinList.add(coinData);
        }
        return publicCoinList;
    }

    public static Pair<class_1792, Integer> getUpwardConversion(class_1792 coinItem) {
        if (moneyData == null) {
            return null;
        }
        class_1792 largeCoin = null;
        int amount = Integer.MAX_VALUE;
        List<CoinData> coinList = moneyData.getSortedCoinList();
        CoinData smallCoinData = moneyData.getData(coinItem);
        if (smallCoinData == null) {
            return null;
        }
        for (CoinData coinData : coinList) {
            if (coinData.worthOtherCoin != coinItem || coinData.worthOtherCoinCount >= amount || coinData.isHidden || !smallCoinData.chain.contentEquals(coinData.chain)) continue;
            largeCoin = coinData.coinItem;
            amount = coinData.worthOtherCoinCount;
        }
        if (largeCoin != null) {
            return new Pair(largeCoin, (Object)amount);
        }
        return null;
    }

    public static Pair<class_1792, Integer> getDownwardConversion(class_1792 coinItem) {
        if (moneyData == null) {
            return null;
        }
        CoinData data = moneyData.getData(coinItem);
        if (data == null) {
            return null;
        }
        if (data.convertsDownwards()) {
            return data.getDownwardConversion();
        }
        return null;
    }

    public static long displayValueToLong(double displayValue) {
        long baseCoinValue = MoneyUtil.getValue((class_1792)LCConfig.SERVER.valueBaseCoin.get());
        double totalValue = displayValue * (double)baseCoinValue;
        long value = (long)totalValue;
        return totalValue % 1.0 >= 0.5 ? value + 1L : value;
    }

    public static CoinValue displayValueToCoinValue(double displayValue) {
        return new CoinValue(MoneyUtil.displayValueToLong(displayValue));
    }
}

