/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class CoinValue {
    public static final String DEFAULT_KEY = "CoinValue";
    private boolean isFree = false;
    public final List<CoinValuePair> coinValues;
    public static final CoinValue EMPTY = new CoinValue(new CoinValuePair[0]){

        @Override
        public void load(class_2487 compound, String key) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }

        @Override
        public void loadFromOldValue(long oldPrice) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }

        @Override
        public void addValue(CoinValue other) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }

        @Override
        public void addValue(class_1792 coin, int amount) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }

        @Override
        public void removeValue(class_1792 coin, int amount) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }

        @Override
        public void removeValue(CoinValue otherValue) {
            LightmansCurrency.LogError("Attempted to modify the empty constant!", new Throwable());
        }
    };

    public boolean isFree() {
        return this.isFree;
    }

    public void setFree(boolean free) {
        this.isFree = free;
        if (this.isFree) {
            this.coinValues.clear();
        }
    }

    public boolean hasAny() {
        return this.coinValues.size() > 0;
    }

    public boolean isValid() {
        return this.isFree || this.coinValues.size() > 0;
    }

    public CoinValue(class_2487 compound) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.load(compound, DEFAULT_KEY);
        this.roundValue();
    }

    public CoinValue(long rawValue) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.loadFromOldValue(rawValue);
        this.roundValue();
    }

    public CoinValue(class_2371<class_1799> inventory) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.loadFromOldValue(MoneyUtil.getValue(inventory));
        this.roundValue();
    }

    public CoinValue(CoinValue otherValue) {
        this.isFree = otherValue.isFree;
        this.coinValues = new ArrayList<CoinValuePair>();
        if (!this.isFree) {
            for (CoinValuePair pricePair : otherValue.coinValues) {
                this.coinValues.add(pricePair.copy());
            }
            this.roundValue();
        }
    }

    @SafeVarargs
    public CoinValue(CoinValuePair ... priceValues) {
        this.coinValues = new ArrayList<CoinValuePair>();
        for (CoinValuePair value : priceValues) {
            for (CoinValuePair coinValue : this.coinValues) {
                if (coinValue.coin != value.coin) continue;
                coinValue.amount += value.amount;
                value.amount = 0;
            }
            if (value.amount <= 0) continue;
            this.coinValues.add(value);
        }
        this.roundValue();
    }

    private CoinValue(List<CoinValuePair> priceValues, boolean validateChain) {
        if (validateChain) {
            this.coinValues = new ArrayList<CoinValuePair>();
            for (int i = 0; i < priceValues.size(); ++i) {
                this.addValue(priceValues.get((int)i).coin, priceValues.get((int)i).amount);
            }
        } else {
            this.coinValues = priceValues;
            this.roundValue();
        }
    }

    public class_2487 save(class_2487 compound, String key) {
        if (this.isFree) {
            compound.method_10556(key, true);
        } else {
            class_2499 list = new class_2499();
            for (CoinValuePair value : this.coinValues) {
                class_2487 thisCompound = new class_2487();
                class_2960 id = class_7923.field_41178.method_10221((Object)value.coin);
                if (!MoneyUtil.isCoin(value.coin)) continue;
                thisCompound.method_10582("ID", id.toString());
                thisCompound.method_10569("Count", value.amount);
                list.add((Object)thisCompound);
            }
            compound.method_10566(key, (class_2520)list);
        }
        return compound;
    }

    public void encode(class_2540 buffer) {
        class_2487 tag = this.save(new class_2487(), DEFAULT_KEY);
        buffer.method_10794(tag);
    }

    public void load(class_2487 compound, String key) {
        if (compound == null) {
            return;
        }
        if (compound.method_10573(key, 9)) {
            class_2499 listNBT = compound.method_10554(key, 10);
            if (listNBT != null) {
                this.coinValues.clear();
                for (int i = 0; i < listNBT.size(); ++i) {
                    class_2487 thisCompound = listNBT.method_10602(i);
                    class_1792 priceCoin = (class_1792)class_7923.field_41178.method_10223(new class_2960(thisCompound.method_10558("ID")));
                    int amount = thisCompound.method_10550("Count");
                    this.coinValues.add(new CoinValuePair(priceCoin, amount));
                }
            }
        } else if (compound.method_10545(key)) {
            this.setFree(compound.method_10577(key));
        }
    }

    public void loadFromOldValue(long oldPrice) {
        this.coinValues.clear();
        List<class_1799> coinItems = MoneyUtil.getCoinsOfValue(oldPrice);
        for (class_1799 stack : coinItems) {
            class_1792 coinItem = stack.method_7909();
            int amount = stack.method_7947();
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (this.coinValues.get((int)i).coin != coinItem) continue;
                this.coinValues.get((int)i).amount += amount;
                amount = 0;
            }
            if (amount <= 0) continue;
            this.coinValues.add(new CoinValuePair(coinItem, amount));
        }
    }

    public static CoinValue decode(class_2540 buffer) {
        class_2487 tag = buffer.method_30617();
        CoinValue value = new CoinValue(new CoinValuePair[0]);
        value.load(tag, DEFAULT_KEY);
        return value;
    }

    public void addValue(CoinValue other) {
        CoinValue otherPrice = other.copy();
        for (int i = 0; i < this.coinValues.size(); ++i) {
            for (int j = 0; j < otherPrice.coinValues.size(); ++j) {
                if (this.coinValues.get((int)i).coin != otherPrice.coinValues.get((int)j).coin) continue;
                this.coinValues.get((int)i).amount += otherPrice.coinValues.get((int)j).amount;
                otherPrice.coinValues.get((int)j).amount = 0;
            }
        }
        for (CoinValuePair pair : otherPrice.coinValues) {
            if (pair.amount <= 0) continue;
            this.coinValues.add(pair);
        }
        this.roundValue();
    }

    public void addValue(class_1792 coin, int amount) {
        long newValue = this.getRawValue() + MoneyUtil.getValue(coin) * (long)amount;
        this.loadFromOldValue(newValue);
        this.roundValue();
    }

    public void removeValue(class_1792 coin, int amount) {
        long newValue = this.getRawValue() - MoneyUtil.getValue(coin) * (long)amount;
        this.loadFromOldValue(newValue);
        this.roundValue();
    }

    public void removeValue(CoinValue otherValue) {
        long thisValue = this.getRawValue();
        long otherVal = otherValue.getRawValue();
        if (otherVal > thisValue) {
            throw new RuntimeException("Other Coin Value is greater than this value.");
        }
        this.loadFromOldValue(thisValue - otherVal);
    }

    private void roundValue() {
        while (this.needsRounding()) {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (!this.needsRounding(i)) continue;
                CoinValuePair pair = this.coinValues.get(i);
                Pair<class_1792, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
                int largeAmount = 0;
                while (pair.amount >= (Integer)conversion.getSecond()) {
                    ++largeAmount;
                    pair.amount -= ((Integer)conversion.getSecond()).intValue();
                }
                if (pair.amount == 0) {
                    this.coinValues.remove(i);
                    --i;
                }
                for (CoinValuePair thisPair : this.coinValues) {
                    if (thisPair.coin != conversion.getFirst()) continue;
                    thisPair.amount += largeAmount;
                    largeAmount = 0;
                }
                if (largeAmount <= 0) continue;
                this.coinValues.add(new CoinValuePair((class_1792)conversion.getFirst(), largeAmount));
            }
        }
        this.sortValue();
    }

    private void sortValue() {
        ArrayList<CoinValuePair> newList = new ArrayList<CoinValuePair>();
        while (this.coinValues.size() > 0) {
            long largestValue = MoneyUtil.getValue(this.coinValues.get((int)0).coin);
            int largestIndex = 0;
            for (int i = 1; i < this.coinValues.size(); ++i) {
                long thisValue = MoneyUtil.getValue(this.coinValues.get((int)i).coin);
                if (thisValue <= largestValue) continue;
                largestIndex = i;
                largestValue = thisValue;
            }
            newList.add(this.coinValues.get(largestIndex));
            this.coinValues.remove(largestIndex);
        }
        for (int i = 0; i < newList.size(); ++i) {
            this.coinValues.add((CoinValuePair)newList.get(i));
        }
    }

    private boolean needsRounding() {
        for (int i = 0; i < this.coinValues.size(); ++i) {
            if (!this.needsRounding(i)) continue;
            return true;
        }
        return false;
    }

    private boolean needsRounding(int index) {
        CoinValuePair pair = this.coinValues.get(index);
        Pair<class_1792, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
        return conversion != null && pair.amount >= (Integer)conversion.getSecond();
    }

    public List<CoinValuePair> getEntries() {
        return this.coinValues;
    }

    public int getEntry(class_1792 coinItem) {
        for (CoinValuePair pair : this.coinValues) {
            if (pair.coin != coinItem) continue;
            return pair.amount;
        }
        return 0;
    }

    public CoinValue copy() {
        return new CoinValue(this);
    }

    public double getDisplayValue() {
        double totalValue = 0.0;
        for (int i = 0; i < this.coinValues.size(); ++i) {
            CoinValuePair pricePair = this.coinValues.get(i);
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            totalValue += coinData.getDisplayValue() * (double)pricePair.amount;
        }
        return totalValue;
    }

    public String getString() {
        return this.getString("");
    }

    public String getString(String emptyFiller) {
        if (this.isFree) {
            return class_2561.method_43471((String)"gui.coinvalue.free").getString();
        }
        switch ((ValueType)((Object)LCConfig.SERVER.coinValueType.get())) {
            case DEFAULT: {
                Object string = "";
                for (int i = 0; i < this.coinValues.size(); ++i) {
                    CoinValuePair pricePair = this.coinValues.get(i);
                    CoinData coinData = MoneyUtil.getData(pricePair.coin);
                    if (coinData == null) continue;
                    string = (String)string + String.valueOf(pricePair.amount);
                    string = (String)string + coinData.getInitial().getString();
                }
                if (((String)string).isBlank()) {
                    return emptyFiller;
                }
                return string;
            }
            case VALUE: {
                return LCConfig.SERVER.formatValueDisplay(this.getDisplayValue());
            }
        }
        return "?";
    }

    public class_5250 getComponent() {
        return this.getComponent("");
    }

    public class_5250 getComponent(String emptyFiller) {
        return class_2561.method_43470((String)this.getString(emptyFiller));
    }

    public long getRawValue() {
        long value = 0L;
        for (CoinValuePair pricePair : this.coinValues) {
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            value += (long)pricePair.amount * coinData.getValue();
        }
        return value;
    }

    public CoinValue ApplyMultiplier(double costMultiplier) {
        CoinValue multipliedValue = new CoinValue(new CoinValuePair[0]);
        if (this.isFree) {
            multipliedValue.setFree(true);
            return multipliedValue;
        }
        costMultiplier = MathUtil.clamp(costMultiplier, 0.0, 10.0);
        for (int i = 0; i < this.coinValues.size(); ++i) {
            int amount = this.coinValues.get((int)i).amount;
            class_1792 coin = this.coinValues.get((int)i).coin;
            double newAmount = (double)amount * costMultiplier;
            double leftoverAmount = newAmount % 1.0;
            multipliedValue.addValue(coin, (int)newAmount);
            CoinData coinData = MoneyUtil.getData(coin);
            while (coinData != null && coinData.convertsDownwards() && leftoverAmount > 0.0) {
                Pair<class_1792, Integer> conversion = coinData.getDownwardConversion();
                coin = (class_1792)conversion.getFirst();
                coinData = MoneyUtil.getData(coin);
                newAmount = leftoverAmount * (double)((Integer)conversion.getSecond()).intValue();
                leftoverAmount = newAmount % 1.0;
                multipliedValue.addValue(coin, (int)newAmount);
            }
        }
        if (multipliedValue.getRawValue() <= 0L) {
            multipliedValue.setFree(true);
        }
        return multipliedValue;
    }

    public Pair<class_1799, class_1799> getTradeItems() {
        List<class_1799> coins = MoneyUtil.getCoinsOfValue(this);
        class_1799 stack1 = class_1799.field_8037;
        class_1799 stack2 = class_1799.field_8037;
        if (coins.size() > 0) {
            stack1 = coins.get(0);
        } else {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
        }
        if (coins.size() > 1) {
            stack2 = coins.get(1);
        }
        if (coins.size() > 2) {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave more than two stacks of coins of output.");
        }
        return new Pair((Object)stack1, (Object)stack2);
    }

    public class_1799 getTradeItem() {
        List<class_1799> coins = MoneyUtil.getCoinsOfValue(this);
        class_1799 stack = class_1799.field_8037;
        if (coins.size() > 0) {
            stack = coins.get(0);
        } else {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
        }
        if (coins.size() > 1) {
            LightmansCurrency.LogWarning("A CoinValue used in a trade output gave more than one stack of coins of output.");
        }
        return stack;
    }

    public static CoinValue easyBuild1(class_1799 ... stack) {
        ArrayList<CoinValuePair> pairs = new ArrayList<CoinValuePair>();
        for (int i = 0; i < stack.length; ++i) {
            if (MoneyUtil.isCoin(stack[i])) {
                pairs.add(new CoinValuePair(stack[i].method_7909(), stack[i].method_7947()));
                continue;
            }
            LightmansCurrency.LogWarning("CoinValue.easyBuild1: ItemStack at index " + i + " is not a valid coin.");
        }
        return new CoinValue(pairs, false);
    }

    public static CoinValue easyBuild2(class_1263 inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static CoinValue Parse(JsonElement json) throws Exception {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return new CoinValue(primitive.getAsNumber().longValue());
            }
            if (primitive.isBoolean() && primitive.getAsBoolean()) {
                CoinValue val = new CoinValue(new CoinValuePair[0]);
                val.setFree(true);
                return val;
            }
            if (primitive.isString()) {
                double displayValue = Double.parseDouble(primitive.getAsString());
                return MoneyUtil.displayValueToCoinValue(displayValue);
            }
        } else if (json.isJsonArray()) {
            ArrayList pairs = Lists.newArrayList();
            JsonArray list = json.getAsJsonArray();
            for (int i = 0; i < list.size(); ++i) {
                JsonObject coinData = list.get(i).getAsJsonObject();
                class_1792 coinItem = class_1802.field_8162;
                int quantity = 1;
                if (coinData.has("Coin")) {
                    coinItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(coinData.get("Coin").getAsString()));
                }
                if (coinData.has("Count")) {
                    quantity = coinData.get("Count").getAsInt();
                }
                if (quantity <= 0) {
                    LightmansCurrency.LogWarning("Coin Count (" + quantity + ") is <= 0. Entry will be ignored.");
                    continue;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogWarning("Coin Item (" + class_7923.field_41178.method_10221((Object)coinItem) + ") is not a valid coin. Entry will be ignored.");
                    continue;
                }
                pairs.add(new CoinValuePair(coinItem, quantity));
            }
            if (pairs.size() <= 0) {
                throw new Exception("Coin Value entry has no valid coin/count entries to parse.");
            }
            return new CoinValue(pairs, true);
        }
        throw new Exception("Coin Value entry input is not a valid Json Element.");
    }

    public JsonElement toJson() {
        if (this.isFree) {
            return new JsonPrimitive(Boolean.valueOf(true));
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.coinValues.size(); ++i) {
            JsonObject entry = new JsonObject();
            CoinValuePair pair = this.coinValues.get(i);
            entry.addProperty("Coin", class_7923.field_41178.method_10221((Object)pair.coin).toString());
            entry.addProperty("Count", (Number)pair.amount);
            array.add((JsonElement)entry);
        }
        return array;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isFree, this.coinValues});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoinValue)) {
            return false;
        }
        CoinValue coinValue = (CoinValue)other;
        if (coinValue.isFree && this.isFree) {
            return true;
        }
        return coinValue.getRawValue() == this.getRawValue();
    }

    public static class CoinValuePair {
        public final class_1792 coin;
        public int amount = 0;

        public CoinValuePair(class_1792 coin, int amount) {
            this.coin = coin;
            this.amount = amount;
        }

        public CoinValuePair copy() {
            return new CoinValuePair(this.coin, this.amount);
        }
    }

    public static enum ValueType {
        DEFAULT,
        VALUE;

    }
}

