/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.MoneyData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CoinData {
    public final class_1792 coinItem;
    public final String chain;
    public final class_1792 worthOtherCoin;
    public final int worthOtherCoinCount;
    private final String initialTranslation;
    private final String pluralTranslation;
    public final boolean isHidden;

    private CoinData(Builder builder) {
        this.coinItem = builder.coinItem;
        this.chain = builder.chain;
        this.worthOtherCoin = builder.worthOtherCoin;
        this.worthOtherCoinCount = builder.worthOtherCoinCount;
        this.initialTranslation = builder.initialTranslation;
        this.pluralTranslation = builder.pluralTranslation;
        this.isHidden = builder.isHidden;
    }

    public long getValue() {
        return this.getValue(MoneyUtil.getMoneyData());
    }

    public long getValue(MoneyData moneyData) {
        if (moneyData == null) {
            return 0L;
        }
        if (!this.convertsDownwards()) {
            return 1L;
        }
        CoinData otherCoinData = moneyData.getData(this.worthOtherCoin);
        if (otherCoinData != null) {
            return (long)this.worthOtherCoinCount * otherCoinData.getValue(moneyData);
        }
        LightmansCurrency.LogError("CoinData.getValue() for " + class_7923.field_41178.method_10221((Object)this.coinItem) + " returning 1 due it's dependent coin (" + class_7923.field_41178.method_10221((Object)this.worthOtherCoin) + ") not being registered.");
        return 1L;
    }

    public double getDisplayValue() {
        double coreValue = this.getValue();
        double baseValue = MoneyUtil.getValue((class_1792)LCConfig.SERVER.valueBaseCoin.get());
        return coreValue / baseValue;
    }

    public boolean convertsDownwards() {
        return this.worthOtherCoin != null && this.worthOtherCoinCount > 0;
    }

    public Pair<class_1792, Integer> getDownwardConversion() {
        return new Pair((Object)this.worthOtherCoin, (Object)this.worthOtherCoinCount);
    }

    public class_5250 getInitial() {
        if (this.initialTranslation != null && !this.initialTranslation.isBlank()) {
            return class_2561.method_43471((String)this.initialTranslation);
        }
        return class_2561.method_43470((String)new class_1799((class_1935)this.coinItem).method_7964().getString().substring(0, 1).toLowerCase());
    }

    public class_5250 getPlural() {
        if (this.pluralTranslation != null && !this.pluralTranslation.isBlank()) {
            return class_2561.method_43471((String)this.pluralTranslation);
        }
        return MoneyUtil.getDefaultPlural(this.coinItem);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("coinitem", class_7923.field_41178.method_10221((Object)this.coinItem).toString());
        json.addProperty("chain", this.chain);
        if (this.worthOtherCoin != null && this.worthOtherCoinCount > 0) {
            JsonObject worth = new JsonObject();
            worth.addProperty("coin", class_7923.field_41178.method_10221((Object)this.worthOtherCoin).toString());
            worth.addProperty("count", (Number)this.worthOtherCoinCount);
            json.add("worth", (JsonElement)worth);
        }
        if (this.initialTranslation != null && !this.initialTranslation.isBlank()) {
            json.addProperty("initial", this.initialTranslation);
        }
        if (this.pluralTranslation != null && !this.pluralTranslation.isBlank()) {
            json.addProperty("plural", this.pluralTranslation);
        }
        if (this.isHidden) {
            json.addProperty("hidden", Boolean.valueOf(true));
        }
        return json;
    }

    public static Builder getBuilder(class_1935 coinItem, String chain) {
        return new Builder(coinItem.method_8389(), chain);
    }

    public static Builder getBuilder(JsonObject json) {
        class_1792 coinItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(json.get("coinitem").getAsString()));
        String chain = json.get("chain").getAsString();
        Builder builder = new Builder(coinItem, chain);
        if (json.has("worth")) {
            JsonObject worthData = json.get("worth").getAsJsonObject();
            class_1792 otherCoin = (class_1792)class_7923.field_41178.method_10223(new class_2960(worthData.get("coin").getAsString()));
            int count = worthData.get("count").getAsInt();
            builder.defineConversion((class_1935)otherCoin, count);
        }
        if (json.has("initial")) {
            builder.defineInitial(json.get("initial").getAsString());
        }
        if (json.has("plural")) {
            builder.definePluralForm(json.get("plural").getAsString());
        }
        if (json.has("hidden") && json.get("hidden").getAsBoolean()) {
            builder.setHidden();
        }
        return builder;
    }

    public static class Builder {
        final class_1792 coinItem;
        final String chain;
        class_1792 worthOtherCoin = null;
        int worthOtherCoinCount = 0;
        String initialTranslation = "";
        String pluralTranslation = "";
        boolean isHidden = false;

        public Builder(@NotNull class_1792 coinItem, String chain) {
            this.coinItem = coinItem;
            this.chain = chain;
        }

        public Builder defineConversion(class_1935 otherCoin, int coinAmount) {
            this.worthOtherCoin = otherCoin.method_8389();
            this.worthOtherCoinCount = coinAmount;
            if (this.worthOtherCoinCount > new class_1799((class_1935)this.worthOtherCoin).method_7914()) {
                this.worthOtherCoinCount = new class_1799((class_1935)this.worthOtherCoin).method_7914();
                LightmansCurrency.LogError("Coin conversion for '" + class_7923.field_41178.method_10221((Object)this.coinItem).toString() + "' is larger than 1 stack of '" + class_7923.field_41178.method_10221((Object)this.worthOtherCoin).toString() + "'\nValue will be shrunk to " + this.worthOtherCoinCount);
            }
            return this;
        }

        public Builder defineInitial(String translationString) {
            this.initialTranslation = translationString;
            return this;
        }

        public Builder definePluralForm(String translationString) {
            this.pluralTranslation = translationString;
            return this;
        }

        public Builder setHidden() {
            this.isHidden = true;
            return this;
        }

        public CoinData build() {
            return new CoinData(this);
        }
    }
}

