/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item.ItemTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ItemTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public ItemTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new ItemTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public ItemTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return ((ItemTraderData)this.menu.getTrader()).getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(ItemTradeData.ItemTradeType type) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeType(type);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("NewType", type.index);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setCustomName(int selectedSlot, String customName) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCustomName(selectedSlot, customName);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("Slot", selectedSlot);
                message.method_10582("CustomName", customName);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setPrice(CoinValue price) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                price.save(message, "NewPrice");
                this.menu.sendMessage(message);
            }
        }
    }

    public void setSelectedItem(int selectedSlot, class_1799 stack) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setItem(stack, selectedSlot);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("Slot", selectedSlot);
                message.method_10566("NewItem", (class_2520)stack.method_7953(new class_2487()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void defaultInteraction(int slotIndex, class_1799 heldStack, int mouseButton) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.onSlotInteraction(this, slotIndex, heldStack, mouseButton);
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("Interaction", slotIndex);
                message.method_10569("Button", mouseButton);
                message.method_10566("Item", (class_2520)heldStack.method_7953(new class_2487()));
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10545("TradeIndex")) {
            this.tradeIndex = message.method_10550("TradeIndex");
        } else if (message.method_10545("Slot")) {
            int slot = message.method_10550("Slot");
            if (message.method_10545("CustomName")) {
                this.setCustomName(slot, message.method_10558("CustomName"));
            } else if (message.method_10545("NewItem")) {
                this.setSelectedItem(slot, class_1799.method_7915((class_2487)message.method_10562("NewItem")));
            }
        } else if (message.method_10545("NewPrice")) {
            CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
            price.load(message, "NewPrice");
            this.setPrice(price);
        } else if (message.method_10545("NewType")) {
            this.setType(ItemTradeData.ItemTradeType.fromIndex(message.method_10550("NewType")));
        } else if (message.method_10545("Interaction")) {
            int index = message.method_10550("Interaction");
            int button = message.method_10550("Button");
            this.defaultInteraction(index, class_1799.method_7915((class_2487)message.method_10562("Item")), button);
        }
    }
}

