/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionTradeCancelClientTab;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_2487;

public class AuctionTradeCancelTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public AuctionTradeCancelTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new AuctionTradeCancelClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return this.menu.getTrader() instanceof AuctionHouseTrader;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public AuctionTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)traderData;
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return ((AuctionHouseTrader)this.menu.getTrader()).getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void cancelAuction(boolean giveToPlayer) {
        TraderData t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionTradeData trade = trader.getTrade(this.tradeIndex);
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("CancelAuction", giveToPlayer);
                this.menu.sendMessage(message);
                return;
            }
            if (trade.isOwner(this.menu.player)) {
                trade.CancelTrade(trader, giveToPlayer, this.menu.player);
                trader.markTradesDirty();
                trader.markStorageDirty();
                class_2487 message = new class_2487();
                message.method_10556("CancelSuccess", true);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10545("TradeIndex")) {
            this.tradeIndex = message.method_10550("TradeIndex");
        }
        if (message.method_10545("CancelAuction")) {
            this.cancelAuction(message.method_10577("CancelAuction"));
        }
    }
}

