/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.network.client.messages.trader.SMessageStorageInteraction;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageStorageInteraction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class TraderStorageMenu
extends Menu {
    public final Supplier<TraderData> traderSource;
    public final class_1657 player;
    public static final int SLOT_OFFSET = 15;
    class_1263 coinSlotContainer = new class_1277(5);
    List<CoinSlot> coinSlots = new ArrayList<CoinSlot>();
    private boolean canEditTabs;
    Map<Integer, TraderStorageTab> availableTabs = new HashMap<Integer, TraderStorageTab>();
    int currentTab = 0;
    private final List<Consumer<class_2487>> listeners = new ArrayList<Consumer<class_2487>>();

    public final TraderData getTrader() {
        return this.traderSource.get();
    }

    public List<CoinSlot> getCoinSlots() {
        return this.coinSlots;
    }

    public boolean coinSlotsActive() {
        return this.coinSlots.get(0).method_7682();
    }

    public Map<Integer, TraderStorageTab> getAllTabs() {
        return this.availableTabs;
    }

    public void setTab(int key, TraderStorageTab tab) {
        if (this.canEditTabs && tab != null) {
            this.availableTabs.put(key, tab);
        } else if (tab == null) {
            LightmansCurrency.LogError("Attempted to set a null storage tab in slot " + key);
        } else {
            LightmansCurrency.LogError("Attempted to define the tab in " + key + " but the tabs have been locked.");
        }
    }

    public int getCurrentTabIndex() {
        return this.currentTab;
    }

    public TraderStorageTab getCurrentTab() {
        return this.availableTabs.get(this.currentTab);
    }

    public TradeContext getContext() {
        return TradeContext.createStorageMode(this.traderSource.get());
    }

    public boolean isClient() {
        return this.player.method_37908().field_9236;
    }

    public TraderStorageMenu(int windowID, class_1661 inventory, long traderID) {
        this(ModMenus.TRADER_STORAGE, windowID, inventory, () -> TraderSaveData.GetTrader(inventory.field_7546.method_37908().field_9236, traderID));
    }

    protected TraderStorageMenu(class_3917<?> type, int windowID, class_1661 inventory, Supplier<TraderData> traderSource) {
        super(type, windowID);
        int x;
        this.traderSource = traderSource;
        this.player = inventory.field_7546;
        this.canEditTabs = true;
        TraderData trader = this.traderSource.get();
        this.setTab(0, new BasicTradeEditTab(this));
        if (trader != null) {
            trader.initStorageTabs(this);
        }
        this.canEditTabs = false;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.method_7621(new class_1735((class_1263)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coinSlotContainer.method_5439(); ++x) {
            CoinSlot newSlot = new CoinSlot(this.coinSlotContainer, x, 23 + (x + 4) * 18, 122);
            this.coinSlots.add(newSlot);
            this.method_7621(newSlot);
        }
        this.availableTabs.forEach((key, tab) -> tab.addStorageMenuSlots(x$0 -> this.method_7621((class_1735)x$0)));
        try {
            this.getCurrentTab().onTabOpen();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.getTrader().userOpen(this.player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, this.coinSlotContainer);
        this.availableTabs.forEach((key, tab) -> tab.onMenuClose());
        TraderData trader = this.getTrader();
        if (trader != null) {
            trader.userClose(player);
        }
    }

    public void clearContainer(class_1263 container) {
        this.method_7607(this.player, container);
    }

    public boolean method_7597(class_1657 player) {
        return this.traderSource != null && this.traderSource.get() != null && this.traderSource.get().hasPermission(player, "openStorage");
    }

    public void validateCoinSlots() {
        boolean canAddCoins = this.hasCoinSlotAccess();
        for (CoinSlot slot : this.coinSlots) {
            slot.active = canAddCoins;
        }
    }

    private boolean hasCoinSlotAccess() {
        TraderData trader = this.getTrader();
        return trader == null ? false : trader.hasPermission(this.player, "storeCoins") && !trader.hasBankAccount();
    }

    public class_1799 method_7601(class_1657 playerEntity, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            if (index < 36 ? !this.getCurrentTab().quickMoveStack(slotStack) && (this.hasCoinSlotAccess() ? !this.method_7616(slotStack, 36, 36 + this.coinSlots.size(), false) && !this.method_7616(slotStack, 36 + this.coinSlots.size(), this.field_7761.size(), false) : !this.method_7616(slotStack, 36 + this.coinSlots.size(), this.field_7761.size(), false)) : index < this.field_7761.size() && !this.method_7616(slotStack, 0, 36, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public boolean hasPermission(String permission) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            return trader.hasPermission(this.player, permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            return trader.getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    public void changeTab(int key) {
        if (this.currentTab == key) {
            return;
        }
        if (this.availableTabs.containsKey(key)) {
            if (this.availableTabs.get(key).canOpen(this.player)) {
                this.getCurrentTab().onTabClose();
                this.currentTab = key;
                this.getCurrentTab().onTabOpen();
            }
        } else {
            LightmansCurrency.LogWarning("Trader Storage Menu doesn't have a tab defined for " + key);
        }
    }

    public class_2487 createTabChangeMessage(int newTab, @Nullable class_2487 extraData) {
        class_2487 message = extraData == null ? new class_2487() : extraData;
        message.method_10569("ChangeTab", newTab);
        return message;
    }

    public class_2487 createCoinSlotActiveMessage(boolean nowActive, @Nullable class_2487 extraData) {
        class_2487 message = extraData == null ? new class_2487() : extraData;
        message.method_10556("SetCoinSlotsActive", nowActive);
        return message;
    }

    public void sendMessage(class_2487 message) {
        if (this.isClient()) {
            new CMessageStorageInteraction(message).sendToServer();
        } else {
            new SMessageStorageInteraction(message).sendTo(this.player);
        }
    }

    public void receiveMessage(class_2487 message) {
        if (message.method_10573("ChangeTab", 3)) {
            this.changeTab(message.method_10550("ChangeTab"));
        }
        if (message.method_10545("SetCoinSlotsActive")) {
            SimpleSlot.SetActive(this.coinSlots, message.method_10577("SetCoinSlotsActive"));
        }
        try {
            this.getCurrentTab().receiveMessage(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Consumer<class_2487> listener : this.listeners) {
            try {
                listener.accept(message);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addMessageListener(Consumer<class_2487> listener) {
        if (!this.listeners.contains(listener) && listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean HasCoinsToAdd() {
        return MoneyUtil.getValue(this.coinSlotContainer) > 0L;
    }

    public void CollectCoinStorage() {
        TraderData trader = this.getTrader();
        if (trader == null) {
            this.closeMenu(this.player);
            return;
        }
        if (trader.hasPermission(this.player, "collectCoins")) {
            TradeContext tempContext;
            CoinValue storedMoney = trader.getInternalStoredMoney();
            if (storedMoney.getRawValue() > 0L && (tempContext = TradeContext.create(trader, this.player).withCoinSlots(this.coinSlotContainer).build()).givePayment(storedMoney)) {
                trader.clearStoredMoney();
            }
        } else {
            Permissions.PermissionWarning(this.player, "collect stored coins", "collectCoins");
        }
    }

    public void AddCoins() {
        TraderData trader = this.getTrader();
        if (trader == null) {
            this.closeMenu(this.player);
            return;
        }
        if (trader.hasPermission(this.player, "storeCoins")) {
            CoinValue addAmount = CoinValue.easyBuild2(this.coinSlotContainer);
            trader.addStoredMoney(addAmount);
            this.coinSlotContainer.method_5448();
        } else {
            Permissions.PermissionWarning(this.player, "store coins", "storeCoins");
        }
    }

    public static interface IClientMessage {
        public void selfMessage(class_2487 var1);
    }
}

