/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import io.github.lightman314.lightmanscurrency.client.data.ClientEjectionData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientTrader;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateEjectionData;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EjectionSaveData
extends class_18 {
    private List<EjectionData> emergencyEjectionData = new ArrayList<EjectionData>();

    private EjectionSaveData() {
    }

    private EjectionSaveData(class_2487 compound) {
        class_2499 ejectionData = compound.method_10554("EmergencyEjectionData", 10);
        for (int i = 0; i < ejectionData.size(); ++i) {
            try {
                EjectionData e = EjectionData.loadData(ejectionData.method_10602(i));
                if (e == null || e.method_5442()) continue;
                this.emergencyEjectionData.add(e);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading ejection data entry " + i, t);
            }
        }
        LightmansCurrency.LogDebug("Server loaded " + this.emergencyEjectionData.size() + " ejection data entries from file.");
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 ejectionData = new class_2499();
        this.emergencyEjectionData.forEach(data -> ejectionData.add((Object)data.save()));
        compound.method_10566("EmergencyEjectionData", (class_2520)ejectionData);
        return compound;
    }

    private static EjectionSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (EjectionSaveData)level.method_17983().method_17924(EjectionSaveData::new, EjectionSaveData::new, "lightmanscurrency_ejection_data");
        }
        return null;
    }

    public static List<EjectionData> GetEjectionData(boolean isClient) {
        if (isClient) {
            return ClientEjectionData.GetEjectionData();
        }
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            return new ArrayList<EjectionData>(esd.emergencyEjectionData);
        }
        return new ArrayList<EjectionData>();
    }

    public static List<EjectionData> GetValidEjectionData(boolean isClient, class_1657 player) {
        List<EjectionData> ejectionData = EjectionSaveData.GetEjectionData(isClient);
        if (ejectionData != null) {
            return ejectionData.stream().filter(e -> e.canAccess(player)).collect(Collectors.toList());
        }
        return new ArrayList<EjectionData>();
    }

    @Deprecated
    public static void GiveOldEjectionData(EjectionData data) {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null && data != null && !data.method_5442()) {
            esd.emergencyEjectionData.add(data);
            EjectionSaveData.MarkEjectionDataDirty();
        }
    }

    public static void HandleEjectionData(class_1937 level, class_2338 pos, EjectionData data) {
        if (level.field_9236) {
            return;
        }
        Objects.requireNonNull(data);
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            esd.emergencyEjectionData.add(data);
            EjectionSaveData.MarkEjectionDataDirty();
        }
    }

    public static void RemoveEjectionData(EjectionData data) {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            Objects.requireNonNull(data);
            if (esd.emergencyEjectionData.contains(data)) {
                esd.emergencyEjectionData.remove(data);
                EjectionSaveData.MarkEjectionDataDirty();
            }
        }
    }

    public static void MarkEjectionDataDirty() {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            esd.method_80();
            class_2487 compound = new class_2487();
            class_2499 ejectionList = new class_2499();
            esd.emergencyEjectionData.forEach(data -> ejectionList.add((Object)data.save()));
            compound.method_10566("EmergencyEjectionData", (class_2520)ejectionList);
            new SMessageUpdateEjectionData(compound).sendToAll();
        }
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            class_2487 compound = new class_2487();
            class_2499 ejectionList = new class_2499();
            esd.emergencyEjectionData.forEach(data -> ejectionList.add((Object)data.save()));
            compound.method_10566("EmergencyEjectionData", (class_2520)ejectionList);
            new SMessageUpdateClientTrader(compound).sendTo(sender);
        }
    }
}

