/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.MoneyValueArgument;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CommandBank {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        LiteralArgumentBuilder bankCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lcbank").requires(stack -> stack.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"give").then(class_2170.method_9247((String)"allPlayers").then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::giveAllPlayers)))).then(class_2170.method_9247((String)"allTeams").then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::giveAllTeams)))).then(class_2170.method_9247((String)"players").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::givePlayers))))).then(class_2170.method_9247((String)"team").then(class_2170.method_9244((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::giveTeam)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"take").then(class_2170.method_9247((String)"allPlayers").then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::takeAllPlayers)))).then(class_2170.method_9247((String)"allTeams").then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::takeAllTeams)))).then(class_2170.method_9247((String)"players").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::takePlayers))))).then(class_2170.method_9247((String)"team").then(class_2170.method_9244((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(class_2170.method_9244((String)"amount", (ArgumentType)MoneyValueArgument.argument(registryAccess)).executes(CommandBank::takeTeam)))));
        dispatcher.register(bankCommand);
    }

    static int giveAllPlayers(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((class_2168)commandContext.getSource(), BankSaveData.GetPlayerBankAccounts(), amount);
    }

    static int giveAllTeams(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((class_2168)commandContext.getSource(), TeamSaveData.GetAllTeams(false).stream().filter(Team::hasBankAccount).map(t -> BankAccount.GenerateReference(false, t)).toList(), amount);
    }

    static int givePlayers(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((class_2168)commandContext.getSource(), class_2186.method_9312(commandContext, (String)"players").stream().map(BankAccount::GenerateReference).toList(), amount);
    }

    static int giveTeam(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        class_2168 source = (class_2168)commandContext.getSource();
        Team team = TeamSaveData.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.team.noteam", teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.team.nobank", teamID));
            return 0;
        }
        return CommandBank.giveTo(source, Lists.newArrayList((Object[])new BankAccount.AccountReference[]{BankAccount.GenerateReference(false, team)}), amount);
    }

    static int giveTo(class_2168 source, List<BankAccount.AccountReference> accounts, CoinValue amount) {
        int count = 0;
        class_5250 bankName = null;
        for (BankAccount.AccountReference account : accounts) {
            if (!BankAccount.ServerGiveCoins(account.get(), amount) || ++count != 1) continue;
            bankName = account.get().getName();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.give.fail", new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSuccess(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.give.success.single", amount.getComponent("NULL"), bankName), true);
        } else {
            EasyText.sendCommandSuccess(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.give.success", amount.getComponent("NULL"), count), true);
        }
        return count;
    }

    static int takeAllPlayers(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((class_2168)commandContext.getSource(), BankSaveData.GetPlayerBankAccounts(), amount);
    }

    static int takeAllTeams(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((class_2168)commandContext.getSource(), TeamSaveData.GetAllTeams(false).stream().filter(Team::hasBankAccount).map(t -> BankAccount.GenerateReference(false, t)).toList(), amount);
    }

    static int takePlayers(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((class_2168)commandContext.getSource(), class_2186.method_9312(commandContext, (String)"players").stream().map(BankAccount::GenerateReference).toList(), amount);
    }

    static int takeTeam(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        CoinValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        class_2168 source = (class_2168)commandContext.getSource();
        Team team = TeamSaveData.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.team.noteam", teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.team.nobank", teamID));
            return 0;
        }
        return CommandBank.takeFrom((class_2168)commandContext.getSource(), Lists.newArrayList((Object[])new BankAccount.AccountReference[]{BankAccount.GenerateReference(false, team)}), amount);
    }

    static int takeFrom(class_2168 source, List<BankAccount.AccountReference> accounts, CoinValue amount) {
        int count = 0;
        class_5250 bankName = null;
        CoinValue largestAmount = new CoinValue(new CoinValue.CoinValuePair[0]);
        for (BankAccount.AccountReference account : accounts) {
            Pair<Boolean, CoinValue> result = BankAccount.ServerTakeCoins(account.get(), amount);
            if (!((Boolean)result.getFirst()).booleanValue()) continue;
            if (++count == 1) {
                bankName = account.get().getName();
            }
            if (((CoinValue)result.getSecond()).getRawValue() <= largestAmount.getRawValue()) continue;
            largestAmount = (CoinValue)result.getSecond();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.take.fail", new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSuccess(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.take.success.single", largestAmount.getComponent("NULL"), bankName), true);
        } else {
            EasyText.sendCommandSuccess(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbank.take.success", largestAmount.getComponent("NULL"), count), true);
        }
        return count;
    }
}

