/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CommandBalTop {
    public static final int ENTRIES_PER_PAGE = 10;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lcbaltop").executes(context -> CommandBalTop.execute((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CommandBalTop::executePage));
        dispatcher.register(lcAdminCommand);
    }

    static int executePage(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        return CommandBalTop.execute(commandContext, IntegerArgumentType.getInteger(commandContext, (String)"page"));
    }

    static int execute(CommandContext<class_2168> commandContext, int page) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        List<BankAccount.AccountReference> allAccounts = BankSaveData.GetPlayerBankAccounts();
        List<Team> allTeams = TeamSaveData.GetAllTeams(false);
        for (Team team : allTeams) {
            if (!team.hasBankAccount()) continue;
            allAccounts.add(BankAccount.GenerateReference(false, team));
        }
        allAccounts.removeIf(bar -> {
            if (bar == null) {
                return true;
            }
            BankAccount ba = bar.get();
            if (ba == null) {
                return true;
            }
            return ba.getCoinStorage().getRawValue() <= 0L;
        });
        if (allAccounts.size() == 0) {
            EasyText.sendCommandFail(source, (class_2561)EasyText.translatable("command.lightmanscurrency.lcbaltop.no_results", new Object[0]));
            return 0;
        }
        allAccounts.sort(new AccountSorter());
        int startIndex = (page - 1) * 10;
        if (startIndex >= allAccounts.size()) {
            EasyText.sendCommandFail(source, (class_2561)class_2561.method_43471((String)"command.lightmanscurrency.lcbaltop.error.page"));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcbaltop.title").method_27692(class_124.field_1067).method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcbaltop.page", (Object[])new Object[]{page, CommandBalTop.getMaxPage(allAccounts.size())}).method_27692(class_124.field_1067).method_27692(class_124.field_1065), false);
        for (int i = startIndex; i < startIndex + 10 && i < allAccounts.size(); ++i) {
            try {
                BankAccount account = allAccounts.get(i).get();
                class_5250 name = account.getName();
                String amount = account.getCoinStorage().getString("0");
                int index = i;
                source.method_9226(() -> CommandBalTop.lambda$execute$4(index, (class_2561)name, amount), false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private static int getMaxPage(int listSize) {
        return (listSize - 1) / 10 + 1;
    }

    private static /* synthetic */ class_2561 lambda$execute$4(int index, class_2561 name, String amount) {
        return class_2561.method_43469((String)"command.lightmanscurrency.lcbaltop.entry", (Object[])new Object[]{index + 1, name, amount});
    }

    private static class AccountSorter
    implements Comparator<BankAccount.AccountReference> {
        private AccountSorter() {
        }

        @Override
        public int compare(BankAccount.AccountReference o1, BankAccount.AccountReference o2) {
            long bal2;
            BankAccount a2;
            BankAccount a1 = o1 == null ? null : o1.get();
            BankAccount bankAccount = a2 = o2 == null ? null : o2.get();
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            long bal1 = a1.getCoinStorage().getRawValue();
            if (bal1 > (bal2 = a2.getCoinStorage().getRawValue())) {
                return -1;
            }
            if (bal2 > bal1) {
                return 1;
            }
            return a1.getName().getString().toLowerCase().compareTo(a2.getName().getString().toLowerCase());
        }
    }
}

