/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.util;

import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import org.joml.Vector3f;

public class LazyShapes {
    public static final class_265 SHORT_BOX = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final Function<class_2350, class_265> SHORT_BOX_SHAPE = LazyShapes.lazySingleShape(SHORT_BOX);
    public static final class_265 BOX = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final Function<class_2350, class_265> BOX_SHAPE = LazyShapes.lazySingleShape(BOX);
    public static final class_265 TALL_BOX = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final BiFunction<class_2350, Boolean, class_265> TALL_BOX_SHAPE = LazyShapes.lazyTallSingleShape(TALL_BOX);
    public static final class_265 WIDE_BOX_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
    public static final class_265 WIDE_BOX_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0);
    public static final class_265 WIDE_BOX_SOUTH = class_2248.method_9541((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final class_265 WIDE_BOX_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BiFunction<class_2350, Boolean, class_265> WIDE_BOX_SHAPE = LazyShapes.lazyWideDirectionalShape(WIDE_BOX_NORTH, WIDE_BOX_EAST, WIDE_BOX_SOUTH, WIDE_BOX_WEST);
    public static final class_265 TALL_WIDE_BOX_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)32.0, (double)16.0);
    public static final class_265 TALL_WIDE_BOX_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)32.0);
    public static final class_265 TALL_WIDE_BOX_SOUTH = class_2248.method_9541((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    public static final class_265 TALL_WIDE_BOX_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)32.0, (double)16.0);
    public static final TriFunction<class_2350, Boolean, Boolean, class_265> TALL_WIDE_BOX_SHAPE = LazyShapes.lazyTallWideDirectionalShape(TALL_WIDE_BOX_NORTH, TALL_WIDE_BOX_EAST, TALL_WIDE_BOX_SOUTH, TALL_WIDE_BOX_WEST);

    public static Function<class_2350, class_265> lazySingleShape(class_265 shape) {
        return facing -> shape;
    }

    public static Function<class_2350, class_265> lazyDirectionalShape(class_265 north, class_265 east, class_265 south, class_265 west) {
        return new LazyDirectionShapeHandler(north, east, south, west);
    }

    public static BiFunction<class_2350, Boolean, class_265> lazyTallSingleShape(class_265 shape) {
        return (facing, isBottom) -> {
            if (isBottom.booleanValue()) {
                return shape;
            }
            return LazyShapes.moveDown(shape);
        };
    }

    public static BiFunction<class_2350, Boolean, class_265> lazyTallDirectionalShape(class_265 north, class_265 east, class_265 south, class_265 west) {
        return new LazyDirectionTallShapeHandler(north, east, south, west);
    }

    public static BiFunction<class_2350, Boolean, class_265> lazyWideDirectionalShape(class_265 north, class_265 east, class_265 south, class_265 west) {
        return new LazyDirectionWideShapeHandler(north, east, south, west);
    }

    public static TriFunction<class_2350, Boolean, Boolean, class_265> lazyTallWideDirectionalShape(BiFunction<class_2350, Boolean, class_265> tallShape) {
        return new LazyDirectionTallWideShapeHandler(tallShape);
    }

    public static TriFunction<class_2350, Boolean, Boolean, class_265> lazyTallWideDirectionalShape(class_265 north, class_265 east, class_265 south, class_265 west) {
        return new LazyDirectionTallWideShapeHandler(north, east, south, west);
    }

    public static class_265 moveDown(class_265 shape) {
        return shape.method_1096(0.0, -1.0, 0.0);
    }

    protected static class LazyDirectionShapeHandler
    implements Function<class_2350, class_265> {
        private final class_265 north;
        private final class_265 east;
        private final class_265 south;
        private final class_265 west;

        public LazyDirectionShapeHandler(class_265 north, class_265 east, class_265 south, class_265 west) {
            this.north = north;
            this.east = east;
            this.south = south;
            this.west = west;
        }

        @Override
        public class_265 apply(class_2350 facing) {
            return switch (facing) {
                case class_2350.field_11034 -> this.east;
                case class_2350.field_11035 -> this.south;
                case class_2350.field_11039 -> this.west;
                default -> this.north;
            };
        }
    }

    protected static class LazyDirectionTallShapeHandler
    implements BiFunction<class_2350, Boolean, class_265> {
        private final Function<class_2350, class_265> lazyShape;

        public LazyDirectionTallShapeHandler(class_265 north, class_265 east, class_265 south, class_265 west) {
            this.lazyShape = LazyShapes.lazyDirectionalShape(north, east, south, west);
        }

        @Override
        public class_265 apply(class_2350 facing, Boolean isBottom) {
            class_265 shape = this.lazyShape.apply(facing);
            if (isBottom.booleanValue()) {
                return shape;
            }
            return LazyShapes.moveDown(shape);
        }
    }

    protected static class LazyDirectionWideShapeHandler
    implements BiFunction<class_2350, Boolean, class_265> {
        private final Function<class_2350, class_265> lazyShape;

        public LazyDirectionWideShapeHandler(class_265 north, class_265 east, class_265 south, class_265 west) {
            this.lazyShape = LazyShapes.lazyDirectionalShape(north, east, south, west);
        }

        @Override
        public class_265 apply(class_2350 facing, Boolean isLeft) {
            class_265 shape = this.lazyShape.apply(facing);
            if (isLeft.booleanValue()) {
                return shape;
            }
            Vector3f offset = IRotatableBlock.getLeftVect(facing);
            return shape.method_1096((double)offset.x(), (double)offset.y(), (double)offset.z());
        }
    }

    protected static class LazyDirectionTallWideShapeHandler
    implements TriFunction<class_2350, Boolean, Boolean, class_265> {
        private final BiFunction<class_2350, Boolean, class_265> lazyShape;

        public LazyDirectionTallWideShapeHandler(BiFunction<class_2350, Boolean, class_265> tallShape) {
            this.lazyShape = tallShape;
        }

        public LazyDirectionTallWideShapeHandler(class_265 north, class_265 east, class_265 south, class_265 west) {
            this.lazyShape = LazyShapes.lazyTallDirectionalShape(north, east, south, west);
        }

        @Override
        public class_265 apply(class_2350 facing, Boolean isBottom, Boolean isLeft) {
            class_265 shape = this.lazyShape.apply(facing, isBottom);
            if (isLeft.booleanValue()) {
                return shape;
            }
            Vector3f offset = IRotatableBlock.getLeftVect(facing);
            return shape.method_1096((double)offset.x(), (double)offset.y(), (double)offset.z());
        }
    }

    public static interface TriFunction<T, U, V, W> {
        public W apply(T var1, U var2, V var3);
    }
}

