/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderinterface.templates;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.network.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public abstract class TraderInterfaceBlock
extends RotatableBlock
implements class_2343,
IOwnableBlock {
    protected TraderInterfaceBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return TickerUtil.createTickerHelper(type, this.interfaceType(), TickableBlockEntity::tickHandler);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        TraderInterfaceBlockEntity blockEntity;
        if (!level.field_9236 && (blockEntity = this.getBlockEntity((class_1936)level, pos, state)) != null) {
            BlockEntityUtil.sendUpdatePacket(blockEntity);
            blockEntity.openMenu(player);
        }
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (!level.field_9236 && placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            TraderInterfaceBlockEntity blockEntity = this.getBlockEntity((class_1936)level, pos, state);
            if (blockEntity != null) {
                blockEntity.initOwner(player);
            }
        }
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        TraderInterfaceBlockEntity blockEntity = this.getBlockEntity((class_1936)level, pos, state);
        if (blockEntity != null) {
            if (!blockEntity.isOwner(player)) {
                return;
            }
            InventoryUtil.dumpContents(level, pos, blockEntity.getContents(level, pos, state, !player.method_7337()));
            blockEntity.flagAsRemovable();
        }
        super.method_9576(level, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean flag) {
        TraderInterfaceBlockEntity blockEntity;
        if (state.method_26204() == newState.method_26204()) {
            return;
        }
        if (!level.field_9236 && (blockEntity = this.getBlockEntity((class_1936)level, pos, state)) != null) {
            if (!blockEntity.allowRemoval()) {
                LightmansCurrency.LogError("Trader block at " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + " was broken by illegal means!");
                LightmansCurrency.LogError("Activating emergency eject protocol.");
                EjectionData data = EjectionData.create(level, pos, state, blockEntity);
                EjectionSaveData.HandleEjectionData(level, pos, data);
                blockEntity.flagAsRemovable();
                try {
                    this.onInvalidRemoval(state, level, pos, blockEntity);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                LightmansCurrency.LogDebug("Trader block was broken by legal means!");
            }
        }
        super.method_9536(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(class_2680 var1, class_1937 var2, class_2338 var3, TraderInterfaceBlockEntity var4);

    @Override
    public boolean canBreak(class_1657 player, class_1936 level, class_2338 pos, class_2680 state) {
        TraderInterfaceBlockEntity be = this.getBlockEntity(level, pos, state);
        if (be == null) {
            return true;
        }
        return be.isOwner(player);
    }

    protected abstract class_2591<?> interfaceType();

    protected final TraderInterfaceBlockEntity getBlockEntity(class_1936 level, class_2338 pos, class_2680 state) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof TraderInterfaceBlockEntity) {
            return (TraderInterfaceBlockEntity)be;
        }
        return null;
    }

    protected Supplier<List<class_2561>> getItemTooltips() {
        return () -> new ArrayList();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.method_9568(stack, level, tooltip, flag);
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public class_1799 getDropBlockItem(class_2680 state, TraderInterfaceBlockEntity traderInterface) {
        return new class_1799((class_1935)state.method_26204());
    }
}

