/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.SidedStorageExtensionBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public abstract class TraderBlockBase
extends class_2248
implements ITraderBlock,
class_2343 {
    private final class_265 shape;

    public TraderBlockBase(class_4970.class_2251 properties) {
        this(properties, LazyShapes.BOX);
    }

    public TraderBlockBase(class_4970.class_2251 properties, class_265 shape) {
        super(properties.method_50012(class_3619.field_15972));
        this.shape = shape != null ? shape : LazyShapes.BOX;
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return this.shape;
    }

    protected boolean shouldMakeTrader(class_2680 state) {
        return true;
    }

    protected abstract class_2586 makeTrader(class_2338 var1, class_2680 var2);

    protected class_2586 makeDummy(class_2338 pos, class_2680 state) {
        return new SidedStorageExtensionBlockEntity(pos, state);
    }

    protected abstract class_2591<?> traderType();

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        class_5558 ticker = TickerUtil.createTickerHelper(type, this.traderType(), TickableBlockEntity::tickHandler);
        if (ticker != null) {
            return ticker;
        }
        return null;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (this.shouldMakeTrader(state)) {
            return this.makeTrader(pos, state);
        }
        return this.makeDummy(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        class_2586 blockEntity;
        if (!level.field_9236 && (blockEntity = this.getBlockEntity(state, (class_1936)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            Object trader = traderSource.getTraderData();
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader Data for block at " + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + " had to be re-initialized on interaction.");
                player.method_43496((class_2561)class_2561.method_43471((String)"trader.warning.reinitialized").method_27692(class_124.field_1061));
                traderSource.initialize(player, class_1799.field_8037);
                trader = traderSource.getTraderData();
            }
            if (trader != null) {
                if (((TraderData)trader).shouldAlwaysShowOnTerminal()) {
                    ((TraderData)trader).openStorageMenu(player);
                } else {
                    ((TraderData)trader).openTraderMenu(player);
                }
            }
        }
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 player, class_1799 stack) {
        this.onPlacedBase(level, pos, state, player, stack);
    }

    public final void onPlacedBase(class_1937 level, class_2338 pos, class_2680 state, class_1309 entity, class_1799 stack) {
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2586 blockEntity = this.getBlockEntity(state, (class_1936)level, pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
                traderSource.initialize(player, stack);
            } else {
                LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when placing the block.");
            }
        }
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        this.onBreakBase(level, pos, state, player);
    }

    public final void onBreakBase(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = this.getBlockEntity(state, (class_1936)level, pos);
        if (blockEntity instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (!traderSource.canBreak(player)) {
                return;
            }
            traderSource.flagAsLegitBreak();
            Object trader = traderSource.getTraderData();
            if (trader != null) {
                InventoryUtil.dumpContents(level, pos, ((TraderData)trader).getContents(level, pos, state, !player.method_7337()));
            }
            traderSource.deleteTrader();
        } else {
            LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when destroying the block.");
        }
        super.method_9576(level, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean flag) {
        class_2586 blockEntity;
        if (state.method_26204() == newState.method_26204()) {
            return;
        }
        if (!level.field_9236 && (blockEntity = this.getBlockEntity(state, (class_1936)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity traderSource = (TraderBlockEntity)blockEntity;
            if (!traderSource.legitimateBreak()) {
                traderSource.flagAsLegitBreak();
                Object trader = traderSource.getTraderData();
                if (trader != null) {
                    LightmansCurrency.LogError("Trader block at " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + " was broken by illegal means!");
                    LightmansCurrency.LogError("Activating emergency eject protocol.");
                    EjectionData data = EjectionData.create(level, pos, state, trader);
                    EjectionSaveData.HandleEjectionData(level, pos, data);
                    TraderSaveData.DeleteTrader(((TraderData)trader).getID());
                }
                try {
                    this.onInvalidRemoval(state, level, pos, (TraderData)trader);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                traderSource.deleteTrader();
            } else {
                LightmansCurrency.LogDebug("Trader block was broken by legal means!");
            }
            traderSource.deleteTrader();
        }
        super.method_9536(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(class_2680 var1, class_1937 var2, class_2338 var3, TraderData var4);

    public boolean canEntityDestroy(class_2680 state, class_1922 level, class_2338 pos, class_1297 entity) {
        return false;
    }

    @Override
    public class_2586 getBlockEntity(class_2680 state, class_1936 level, class_2338 pos) {
        return level == null ? null : level.method_8321(pos);
    }

    protected Supplier<List<class_2561>> getItemTooltips() {
        return () -> new ArrayList();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flagIn) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.method_9568(stack, level, tooltip, flagIn);
    }
}

