/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockTallWideRotatable;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VendingMachineLargeBlock
extends TraderBlockTallWideRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 12;

    public VendingMachineLargeBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2586 makeTrader(class_2338 pos, class_2680 state) {
        return new ItemTraderBlockEntity(pos, state, 12);
    }

    @Override
    public class_2591<?> traderType() {
        return ModBlockEntities.ITEM_TRADER;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, class_2680 state, boolean isDoubleTrade) {
        class_2350 facing = this.getFacing(state);
        Vector3f forward = IRotatableBlock.getForwardVect(facing);
        Vector3f right = IRotatableBlock.getRightVect(facing);
        Vector3f up = MathUtil.YP();
        Vector3f offset = IRotatableBlock.getOffsetVect(facing);
        Vector3f forwardOffset = MathUtil.VectorMult(forward, 0.375f);
        Vector3f firstPosition = null;
        if (tradeSlot == 0) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 1) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 2) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 3) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 1.6875f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 4) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 5) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 6) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 7) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 1.25f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 8) {
            rightOffset = MathUtil.VectorMult(right, 0.21875f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 9) {
            rightOffset = MathUtil.VectorMult(right, 0.65625f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 10) {
            rightOffset = MathUtil.VectorMult(right, 1.09375f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 11) {
            rightOffset = MathUtil.VectorMult(right, 1.53125f);
            vertOffset = MathUtil.VectorMult(up, 0.8125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(3);
        if (firstPosition != null) {
            posList.add(firstPosition);
            for (float distance = 3.2f; distance < 7.0f; distance += 3.2f) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(forward, distance / 16.0f)));
            }
        } else {
            posList.add(new Vector3f(0.0f, 1.0f, 0.0f));
        }
        return posList;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, class_2680 state) {
        ArrayList<Quaternionf> rotation = new ArrayList<Quaternionf>();
        int facing = this.getFacing(state).method_10161();
        rotation.add(MathUtil.getRotationDegrees((float)facing * -90.0f));
        return rotation;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float GetStackRenderScale(int tradeSlot, class_2680 state) {
        return 0.3f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int maxRenderIndex() {
        return 12;
    }

    @Override
    protected Supplier<List<class_2561>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }
}

