/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderinterface.templates.TraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menu.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traderinterface.NetworkTradeReference;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.Handler;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.SpeedUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.network.server.messages.traderinterface.CMessageHandlerMessage;
import io.github.lightman314.lightmanscurrency.network.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TraderInterfaceBlockEntity
extends TickableBlockEntity
implements UpgradeType.IUpgradeable,
IDumpable,
IClientTracker,
SidedStorageBlockEntity {
    public static final int INTERACTION_DELAY = 20;
    private boolean allowRemoval = false;
    public final OwnerData owner = new OwnerData(this, o -> BlockEntityUtil.sendUpdatePacket(this, this.saveOwner(this.saveMode(new class_2487()))));
    List<Handler> handlers = new ArrayList<Handler>();
    private ActiveMode mode = ActiveMode.DISABLED;
    private boolean onlineMode = false;
    private InteractionType interaction = InteractionType.TRADE;
    NetworkTradeReference reference = new NetworkTradeReference(this::isClient, this::deserializeTrade);
    private class_1277 upgradeSlots = new class_1277(5);
    private TradeContext.TradeResult lastResult = TradeContext.TradeResult.SUCCESS;
    private int waitTimer = 20;

    public boolean allowRemoval() {
        return this.allowRemoval;
    }

    public void flagAsRemovable() {
        this.allowRemoval = true;
    }

    public void initOwner(class_1657 owner) {
        if (!this.owner.hasOwner()) {
            this.owner.SetOwner(PlayerReference.of(owner));
        }
    }

    public void setOwner(String name) {
        PlayerReference newOwner = PlayerReference.of(this.isClient(), name);
        if (newOwner != null) {
            this.owner.SetOwner(newOwner);
            this.mode = ActiveMode.DISABLED;
            this.method_5431();
            if (!this.isClient()) {
                BlockEntityUtil.sendUpdatePacket(this, this.saveOwner(this.saveMode(new class_2487())));
            }
        }
    }

    public void setTeam(long teamID) {
        Team team = TeamSaveData.GetTeam(this.isClient(), teamID);
        if (team != null) {
            this.owner.SetOwner(team);
        }
    }

    public PlayerReference getReferencedPlayer() {
        return this.owner.getPlayerForContext();
    }

    public String getOwnerName() {
        return this.owner.getOwnerName(this.isClient());
    }

    public BankAccount getBankAccount() {
        BankAccount.AccountReference reference = this.getAccountReference();
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public BankAccount.AccountReference getAccountReference() {
        if (this.getOwner().hasTeam()) {
            return BankAccount.GenerateReference(this.isClient(), this.owner.getTeam());
        }
        if (this.owner != null) {
            return BankAccount.GenerateReference(this.isClient(), this.owner.getPlayer());
        }
        return null;
    }

    public ActiveMode getMode() {
        return this.mode;
    }

    public void setMode(ActiveMode mode) {
        this.mode = mode;
        this.setModeDirty();
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean onlineMode) {
        this.onlineMode = onlineMode;
        this.setOnlineModeDirty();
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    public void setInteractionType(InteractionType type) {
        if (this.getBlacklistedInteractions().contains((Object)type)) {
            LightmansCurrency.LogInfo("Attempted to set interaction type to " + type.name() + ", but that type is blacklisted for this interface type (" + this.getClass().getName() + ").");
            return;
        }
        this.interaction = type;
        this.setInteractionDirty();
    }

    public List<InteractionType> getBlacklistedInteractions() {
        return new ArrayList<InteractionType>();
    }

    public boolean hasTrader() {
        return this.getTrader() != null;
    }

    public TraderData getTrader() {
        TraderData trader = this.reference.getTrader();
        if (this.interaction.requiresPermissions && !this.hasTraderPermissions(trader)) {
            return null;
        }
        return trader;
    }

    public int getTradeIndex() {
        return this.reference.getTradeIndex();
    }

    public TradeData getReferencedTrade() {
        return this.reference.getLocalTrade();
    }

    public TradeData getTrueTrade() {
        return this.reference.getTrueTrade();
    }

    public class_1263 getUpgradeInventory() {
        return this.upgradeSlots;
    }

    public void setUpgradeSlotsDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveUpgradeSlots(new class_2487()));
        }
    }

    public void setTrader(long traderID) {
        if (this.reference.getTraderID() == traderID) {
            return;
        }
        this.reference.setTrader(traderID);
        this.reference.setTrade(-1);
        this.setTradeReferenceDirty();
    }

    public void setTradeIndex(int tradeIndex) {
        this.reference.setTrade(tradeIndex);
        this.setTradeReferenceDirty();
    }

    public void acceptTradeChanges() {
        this.reference.refreshTrade();
        this.setTradeReferenceDirty();
    }

    public TradeContext.TradeResult mostRecentTradeResult() {
        return this.lastResult;
    }

    protected abstract TradeData deserializeTrade(class_2487 var1);

    public boolean canAccess(class_1657 player) {
        return this.owner.isMember(player);
    }

    public boolean isOwner(class_1657 player) {
        return this.owner.isAdmin(player);
    }

    protected TraderInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Nullable
    public final Storage<FluidVariant> getFluidStorage(class_2350 side) {
        class_2350 relativeSide = this.getRelativeSide(side);
        for (Handler handler : this.handlers) {
            if (!handler.hasFluidStorage(relativeSide)) continue;
            return handler.getFluidStorage(relativeSide);
        }
        return null;
    }

    @Nullable
    public final Storage<ItemVariant> getItemStorage(class_2350 side) {
        class_2350 relativeSide = this.getRelativeSide(side);
        for (Handler handler : this.handlers) {
            if (!handler.hasItemStorage(relativeSide)) continue;
            return handler.getItemStorage(relativeSide);
        }
        return null;
    }

    public void setModeDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveMode(new class_2487()));
        }
    }

    public void setOnlineModeDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveOnlineMode(new class_2487()));
        }
    }

    public void setLastResultDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveLastResult(new class_2487()));
        }
    }

    protected abstract TradeContext.Builder buildTradeContext(TradeContext.Builder var1);

    public TradeContext getTradeContext() {
        if (this.interaction.trades) {
            return this.buildTradeContext(TradeContext.create(this.getTrader(), this.getReferencedPlayer()).withBankAccount(this.getAccountReference()).withMoneyListener(this::trackMoneyInteraction)).build();
        }
        return TradeContext.createStorageMode(this.getTrader());
    }

    @Override
    public boolean isClient() {
        return this.field_11863 != null ? this.field_11863.field_9236 : true;
    }

    protected final <H extends Handler> H addHandler(@NotNull H handler) {
        handler.setParent(this);
        this.handlers.add(handler);
        return handler;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    protected void method_11007(class_2487 compound) {
        this.saveOwner(compound);
        this.saveMode(compound);
        this.saveOnlineMode(compound);
        this.saveInteraction(compound);
        this.saveLastResult(compound);
        this.saveReference(compound);
        this.saveUpgradeSlots(compound);
        for (Handler handler : this.handlers) {
            this.saveHandler(compound, handler);
        }
    }

    protected final class_2487 saveOwner(class_2487 compound) {
        if (this.owner != null) {
            compound.method_10566("Owner", (class_2520)this.owner.save());
        }
        return compound;
    }

    protected final class_2487 saveMode(class_2487 compound) {
        compound.method_10582("Mode", this.mode.name());
        return compound;
    }

    protected final class_2487 saveOnlineMode(class_2487 compound) {
        compound.method_10556("OnlineMode", this.onlineMode);
        return compound;
    }

    protected final class_2487 saveInteraction(class_2487 compound) {
        compound.method_10582("InteractionType", this.interaction.name());
        return compound;
    }

    protected final class_2487 saveLastResult(class_2487 compound) {
        compound.method_10582("LastResult", this.lastResult.name());
        return compound;
    }

    protected final class_2487 saveReference(class_2487 compound) {
        compound.method_10566("Trade", (class_2520)this.reference.save());
        return compound;
    }

    protected final class_2487 saveUpgradeSlots(class_2487 compound) {
        InventoryUtil.saveAllItems("Upgrades", compound, (class_1263)this.upgradeSlots);
        return compound;
    }

    protected final class_2487 saveHandler(class_2487 compound, Handler handler) {
        compound.method_10566(handler.getTag(), (class_2520)handler.save());
        return compound;
    }

    public void setHandlerDirty(Handler handler) {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveHandler(new class_2487(), handler));
        }
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10573("Owner", 10)) {
            this.owner.load(compound.method_10562("Owner"));
        }
        if (compound.method_10545("Mode")) {
            this.mode = (ActiveMode)EnumUtil.enumFromString((String)compound.method_10558("Mode"), (Enum[])ActiveMode.values(), (Enum)ActiveMode.DISABLED);
        }
        if (compound.method_10545("OnlineMode")) {
            this.onlineMode = compound.method_10577("OnlineMode");
        }
        if (compound.method_10573("InteractionType", 8)) {
            this.interaction = (InteractionType)EnumUtil.enumFromString((String)compound.method_10558("InteractionType"), (Enum[])InteractionType.values(), (Enum)InteractionType.TRADE);
        }
        if (compound.method_10573("Trade", 10)) {
            this.reference.load(compound.method_10562("Trade"));
        }
        if (compound.method_10545("Upgrades")) {
            this.upgradeSlots = InventoryUtil.loadAllItems("Upgrades", compound, 5);
        }
        for (Handler handler : this.handlers) {
            if (!compound.method_10573(handler.getTag(), 10)) continue;
            handler.load(compound.method_10562(handler.getTag()));
        }
    }

    public void setInteractionDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveInteraction(new class_2487()));
        }
    }

    public final class_2350 getRelativeSide(class_2350 side) {
        class_2350 relativeSide = side;
        if (relativeSide != null & this.method_11010().method_26204() instanceof IRotatableBlock) {
            relativeSide = IRotatableBlock.getRelativeSide(((IRotatableBlock)this.method_11010().method_26204()).getFacing(this.method_11010()), side);
        }
        return relativeSide;
    }

    public void sendHandlerMessage(class_2960 type, class_2487 message) {
        if (this.isClient()) {
            new CMessageHandlerMessage(this.field_11867, type, message).sendToServer();
        }
    }

    public void receiveHandlerMessage(class_2960 type, class_1657 player, class_2487 message) {
        if (!this.canAccess(player)) {
            return;
        }
        for (int i = 0; i < this.handlers.size(); ++i) {
            if (!this.handlers.get(i).getType().equals((Object)type)) continue;
            this.handlers.get(i).receiveMessage(message);
        }
    }

    public void setTradeReferenceDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveReference(new class_2487()));
        }
    }

    public TradeContext.TradeResult interactWithTrader() {
        TradeContext tradeContext = this.getTradeContext();
        TraderData trader = this.getTrader();
        this.lastResult = trader != null ? trader.ExecuteTrade(tradeContext, this.reference.getTradeIndex()) : TradeContext.TradeResult.FAIL_NULL;
        this.setLastResultDirty();
        return this.lastResult;
    }

    protected void trackMoneyInteraction(CoinValue price, boolean isDeposit) {
    }

    public boolean isActive() {
        return this.mode.isActive(this) && this.onlineCheck();
    }

    public boolean onlineCheck() {
        if (this.isClient()) {
            return false;
        }
        if (!this.onlineMode) {
            return true;
        }
        MinecraftServer server = ServerHook.getServer();
        if (server == null) {
            return false;
        }
        if (this.owner.hasTeam()) {
            Team team = this.owner.getTeam();
            for (PlayerReference member : team.getAllMembers()) {
                if (member == null || server.method_3760().method_14602(member.id) == null) continue;
                return true;
            }
        } else if (this.owner.hasPlayer()) {
            return server.method_3760().method_14602(this.owner.getPlayer().id) != null;
        }
        return false;
    }

    public final boolean hasTraderPermissions(TraderData trader) {
        if (trader == null) {
            return false;
        }
        Team team = this.owner.getTeam();
        if (team != null) {
            return trader.getOwner().getTeam() == team;
        }
        return trader.hasPermission(this.owner.getPlayer(), "interactionLink");
    }

    @Override
    public void serverTick() {
        if (this.isActive()) {
            --this.waitTimer;
            if (this.waitTimer <= 0) {
                this.waitTimer = this.getInteractionDelay();
                if (this.interaction.requiresPermissions) {
                    if (!this.validTrader() || !this.hasTraderPermissions(this.getTrader())) {
                        return;
                    }
                    if (this.interaction.drains) {
                        this.drainTick();
                    }
                    if (this.interaction.restocks) {
                        this.restockTick();
                    }
                } else if (this.interaction.trades) {
                    if (!this.validTrade()) {
                        return;
                    }
                    this.tradeTick();
                }
                if (this.hasHopperUpgrade()) {
                    this.hopperTick();
                }
            }
        }
    }

    public boolean validTrader() {
        TraderData trader = this.getTrader();
        return trader != null && this.validTraderType(trader);
    }

    public boolean validTrade() {
        TradeData expectedTrade = this.getReferencedTrade();
        TradeData trueTrade = this.getTrueTrade();
        if (expectedTrade == null || trueTrade == null) {
            return false;
        }
        return expectedTrade.AcceptableDifferences(expectedTrade.compare(trueTrade));
    }

    public abstract boolean validTraderType(TraderData var1);

    protected abstract void drainTick();

    protected abstract void restockTick();

    protected abstract void tradeTick();

    protected abstract void hopperTick();

    public void openMenu(class_1657 player) {
        if (this.canAccess(player)) {
            ExtendedScreenHandlerFactory provider = this.getMenuProvider();
            if (provider == null) {
                return;
            }
            player.method_17355((class_3908)provider);
        }
    }

    protected ExtendedScreenHandlerFactory getMenuProvider() {
        return new InterfaceMenuProvider(this.field_11867);
    }

    protected int getInteractionDelay() {
        int delay = 20;
        for (int i = 0; i < this.upgradeSlots.method_5439() && delay > 1; ++i) {
            UpgradeItem upgrade;
            class_1799 stack = this.upgradeSlots.method_5438(i);
            if (!(stack.method_7909() instanceof UpgradeItem) || !((upgrade = (UpgradeItem)stack.method_7909()).getUpgradeType() instanceof SpeedUpgrade)) continue;
            delay -= UpgradeItem.getUpgradeData(stack).getIntValue(SpeedUpgrade.DELAY_AMOUNT);
        }
        return delay;
    }

    public abstract void initMenuTabs(TraderInterfaceMenu var1);

    @Override
    public boolean allowUpgrade(UpgradeType type) {
        return type == UpgradeType.SPEED || type == UpgradeType.HOPPER && this.allowHopperUpgrade() && !this.hasHopperUpgrade() || this.allowAdditionalUpgrade(type);
    }

    protected boolean allowHopperUpgrade() {
        return true;
    }

    protected boolean allowAdditionalUpgrade(UpgradeType type) {
        return false;
    }

    protected final boolean hasHopperUpgrade() {
        return UpgradeType.hasUpgrade(UpgradeType.HOPPER, (class_1263)this.upgradeSlots);
    }

    @Override
    public final List<class_1799> getContents(class_1937 level, class_2338 pos, class_2680 state, boolean dropBlock) {
        ArrayList<class_1799> contents = new ArrayList<class_1799>();
        if (dropBlock) {
            if (state.method_26204() instanceof TraderInterfaceBlock) {
                contents.add(((TraderInterfaceBlock)state.method_26204()).getDropBlockItem(state, this));
            } else {
                contents.add(new class_1799((class_1935)state.method_26204()));
            }
        }
        for (int i = 0; i < this.upgradeSlots.method_5439(); ++i) {
            if (this.upgradeSlots.method_5438(i).method_7960()) continue;
            contents.add(this.upgradeSlots.method_5438(i));
        }
        this.getAdditionalContents(contents);
        return contents;
    }

    protected abstract void getAdditionalContents(List<class_1799> var1);

    @Override
    public OwnerData getOwner() {
        return this.owner;
    }

    public static enum ActiveMode {
        DISABLED(0, be -> false),
        REDSTONE_OFF(1, be -> {
            if (((TraderInterfaceBlockEntity)be).field_11863 != null) {
                return !((TraderInterfaceBlockEntity)be).field_11863.method_49803(((TraderInterfaceBlockEntity)be).field_11867);
            }
            return false;
        }),
        REDSTONE_ONLY(2, be -> {
            if (((TraderInterfaceBlockEntity)be).field_11863 != null) {
                return ((TraderInterfaceBlockEntity)be).field_11863.method_49803(((TraderInterfaceBlockEntity)be).field_11867);
            }
            return false;
        }),
        ALWAYS_ON(3, be -> true);

        public final int index;
        private final Function<TraderInterfaceBlockEntity, Boolean> active;

        public final class_2561 getDisplayText() {
            return class_2561.method_43471((String)("gui.lightmanscurrency.interface.mode." + this.name().toLowerCase()));
        }

        public final ActiveMode getNext() {
            return ActiveMode.fromIndex(this.index + 1);
        }

        public boolean isActive(TraderInterfaceBlockEntity blockEntity) {
            return this.active.apply(blockEntity);
        }

        private ActiveMode(int index, Function<TraderInterfaceBlockEntity, Boolean> active) {
            this.index = index;
            this.active = active;
        }

        public static ActiveMode fromIndex(int index) {
            for (ActiveMode mode : ActiveMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }

    public static enum InteractionType {
        RESTOCK_AND_DRAIN(true, true, true, false, 3),
        RESTOCK(true, true, false, false, 1),
        DRAIN(true, false, true, false, 2),
        TRADE(false, false, false, true, 0);

        public final boolean requiresPermissions;
        public final boolean restocks;
        public final boolean drains;
        public final boolean trades;
        public final int index;

        public final class_2561 getDisplayText() {
            return class_2561.method_43471((String)("gui.lightmanscurrency.interface.type." + this.name().toLowerCase()));
        }

        public final InteractionType getNext() {
            return InteractionType.fromIndex(this.index + 1);
        }

        private InteractionType(boolean requiresPermissions, boolean restocks, boolean drains, boolean trades, int index) {
            this.requiresPermissions = requiresPermissions;
            this.restocks = restocks;
            this.drains = drains;
            this.trades = trades;
            this.index = index;
        }

        public static InteractionType fromIndex(int index) {
            for (InteractionType type : InteractionType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return TRADE;
        }

        public static int size() {
            return 4;
        }
    }

    public static class InterfaceMenuProvider
    implements ExtendedScreenHandlerFactory {
        private final class_2338 blockPos;

        public InterfaceMenuProvider(class_2338 blockPos) {
            this.blockPos = blockPos;
        }

        public class_1703 createMenu(int windowID, class_1661 inventory, class_1657 player) {
            return new TraderInterfaceMenu(windowID, inventory, this.blockPos);
        }

        public class_2561 method_5476() {
            return class_2561.method_43473();
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_10807(this.blockPos);
        }
    }
}

