/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ItemTraderBlockEntity
extends TraderBlockEntity<ItemTraderData> {
    protected long rotationTime = 0L;
    protected int tradeCount;
    protected boolean networkTrader = false;

    public ItemTraderBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntities.ITEM_TRADER, pos, state, 1, false);
    }

    public ItemTraderBlockEntity(class_2338 pos, class_2680 state, int tradeCount) {
        this(ModBlockEntities.ITEM_TRADER, pos, state, tradeCount, false);
    }

    public ItemTraderBlockEntity(class_2338 pos, class_2680 state, int tradeCount, boolean networkTrader) {
        this(ModBlockEntities.ITEM_TRADER, pos, state, tradeCount, networkTrader);
    }

    protected ItemTraderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, 1, false);
    }

    protected ItemTraderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int tradeCount) {
        this(type, pos, state, tradeCount, false);
    }

    protected ItemTraderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int tradeCount, boolean networkTrader) {
        super(type, pos, state);
        this.tradeCount = tradeCount;
        this.networkTrader = networkTrader;
    }

    @Override
    public ItemTraderData buildNewTrader() {
        ItemTraderData trader = new ItemTraderData(this.tradeCount, this.field_11863, this.field_11867);
        if (this.networkTrader) {
            trader.setAlwaysShowOnTerminal();
        }
        return trader;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, boolean isDoubleTrade) {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderPos(tradeSlot, this.method_11010(), isDoubleTrade);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>();
        posList.add(new Vector3f(0.0f, 0.0f, 0.0f));
        return posList;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, float partialTicks) {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            List<Quaternionf> rotation = traderBlock.GetStackRenderRot(tradeSlot, this.method_11010());
            if (rotation == null) {
                rotation = new ArrayList<Quaternionf>();
                rotation.add(MathUtil.getRotationDegrees(((float)this.rotationTime + partialTicks) * 2.0f));
            }
            return rotation;
        }
        ArrayList<Quaternionf> rotation = new ArrayList<Quaternionf>();
        rotation.add(MathUtil.getRotationDegrees(0.0f));
        return rotation;
    }

    @Environment(value=EnvType.CLIENT)
    public float GetStackRenderScale(int tradeSlot) {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderScale(tradeSlot, this.method_11010());
        }
        return 0.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public int maxRenderIndex() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.maxRenderIndex();
        }
        return 0;
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10569("TradeCount", this.tradeCount);
        compound.method_10556("NetworkTrader", this.networkTrader);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.tradeCount = compound.method_10550("TradeCount");
        this.networkTrader = compound.method_10577("NetworkTrader");
    }

    @Override
    public void clientTick() {
        super.clientTick();
        ++this.rotationTime;
    }
}

