/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.common.EventListener;
import io.github.lightman314.lightmanscurrency.common.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.common.atm.ATMData;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import io.github.lightman314.lightmanscurrency.common.callbacks.EntityDeathCallback;
import io.github.lightman314.lightmanscurrency.common.callbacks.MobInitializationCallback;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.CommandLoader;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModCommandArguments;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.core.ModPointsOfInterest;
import io.github.lightman314.lightmanscurrency.common.core.ModProfessions;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.core.VillagerTradeManager;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.enchantments.EnchantmentEvents;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.money.DefaultMoneyDataCollection;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TextNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.item.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.paygate.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataTicket;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.BasicSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.network.PacketChannels;
import io.github.lightman314.lightmanscurrency.network.client.messages.time.SMessageSyncTime;
import io.github.lightman314.lightmanscurrency.network.server.LCServerPacketHandler;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightmansCurrency
implements ModInitializer {
    public static final String MODID = "lightmanscurrency";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"lightmanscurrency");

    public void onInitialize() {
        LightmansCurrency.LogInfo("Registering Lightman's Currency Items/Blocks");
        ModItems.registerItems();
        ModBlocks.registerBlocks();
        ModBlockEntities.registerBlockEntities();
        ModMenus.registerMenus();
        ModEnchantments.registerEnchantments();
        ModPointsOfInterest.registerPointsOfInterest();
        ModProfessions.registerProfessions();
        ModCommandArguments.registerCommandArguments();
        ModRecipes.registerRecipes();
        ModSounds.registerSounds();
        ModCreativeGroups.registerItemGroups();
        ModGameRules.registerGameRules();
        LightmansCurrency.LogInfo("Done registering Lightman's Currency Items/Blocks");
        LCConfig.init();
        LCConfig.COMMON.reload();
        VillagerTradeManager.registerVillagerTrades();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketChannels.CLIENT_TO_SERVER, (ServerPlayNetworking.PlayChannelHandler)new LCServerPacketHandler());
        this.registerEventListeners();
        EventListener.registerEventListeners();
        TraderData.register(ItemTraderData.TYPE, ItemTraderData::new);
        TraderData.register(ItemTraderDataArmor.TYPE, ItemTraderDataArmor::new);
        TraderData.register(ItemTraderDataTicket.TYPE, ItemTraderDataTicket::new);
        TraderData.register(PaygateTraderData.TYPE, PaygateTraderData::new);
        TraderData.register(AuctionHouseTrader.TYPE, AuctionHouseTrader::new);
        TraderData.register(SlotMachineTraderData.TYPE, SlotMachineTraderData::new);
        TradeRule.RegisterDeserializer(PlayerWhitelist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerWhitelist::new));
        TradeRule.RegisterDeserializer(PlayerBlacklist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerBlacklist::new));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)PlayerTradeLimit::new));
        TradeRule.RegisterDeserializer(PlayerDiscounts.TYPE, (Supplier<TradeRule>)((Supplier)PlayerDiscounts::new));
        TradeRule.RegisterDeserializer(TimedSale.TYPE, (Supplier<TradeRule>)((Supplier)TimedSale::new));
        TradeRule.RegisterDeserializer(TradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)TradeLimit::new));
        TradeRule.RegisterDeserializer(FreeSample.TYPE, (Supplier<TradeRule>)((Supplier)FreeSample::new));
        TradeRule.RegisterDeserializer(PriceFluctuation.TYPE, (Supplier<TradeRule>)((Supplier)PriceFluctuation::new));
        Notification.register(ItemTradeNotification.TYPE, ItemTradeNotification::new);
        Notification.register(PaygateNotification.TYPE, PaygateNotification::new);
        Notification.register(OutOfStockNotification.TYPE, OutOfStockNotification::new);
        Notification.register(LowBalanceNotification.TYPE, LowBalanceNotification::new);
        Notification.register(AuctionHouseSellerNotification.TYPE, AuctionHouseSellerNotification::new);
        Notification.register(AuctionHouseBuyerNotification.TYPE, AuctionHouseBuyerNotification::new);
        Notification.register(AuctionHouseSellerNobidNotification.TYPE, AuctionHouseSellerNobidNotification::new);
        Notification.register(AuctionHouseBidNotification.TYPE, AuctionHouseBidNotification::new);
        Notification.register(AuctionHouseCancelNotification.TYPE, AuctionHouseCancelNotification::new);
        Notification.register(TextNotification.TYPE, TextNotification::new);
        Notification.register(AddRemoveAllyNotification.TYPE, AddRemoveAllyNotification::new);
        Notification.register(AddRemoveTradeNotification.TYPE, AddRemoveTradeNotification::new);
        Notification.register(ChangeAllyPermissionNotification.TYPE, ChangeAllyPermissionNotification::new);
        Notification.register(ChangeCreativeNotification.TYPE, ChangeCreativeNotification::new);
        Notification.register(ChangeNameNotification.TYPE, ChangeNameNotification::new);
        Notification.register(ChangeOwnerNotification.TYPE, ChangeOwnerNotification::new);
        Notification.register(ChangeSettingNotification.SIMPLE_TYPE, ChangeSettingNotification.Simple::new);
        Notification.register(ChangeSettingNotification.ADVANCED_TYPE, ChangeSettingNotification.Advanced::new);
        Notification.register(DepositWithdrawNotification.PLAYER_TYPE, DepositWithdrawNotification.Player::new);
        Notification.register(DepositWithdrawNotification.TRADER_TYPE, DepositWithdrawNotification.Trader::new);
        Notification.register(DepositWithdrawNotification.SERVER_TYPE, DepositWithdrawNotification.Server::new);
        Notification.register(BankTransferNotification.TYPE, BankTransferNotification::new);
        Notification.register(SlotMachineTradeNotification.TYPE, SlotMachineTradeNotification::new);
        NotificationCategory.register(NotificationCategory.GENERAL_TYPE, c -> NotificationCategory.GENERAL);
        NotificationCategory.register(NullCategory.TYPE, c -> NullCategory.INSTANCE);
        NotificationCategory.register(TraderCategory.TYPE, TraderCategory::new);
        NotificationCategory.register(BankCategory.TYPE, BankCategory::new);
        NotificationCategory.register(AuctionHouseCategory.TYPE, c -> AuctionHouseCategory.INSTANCE);
        TraderSearchFilter.addFilter(new BasicSearchFilter());
        TraderSearchFilter.addFilter(new ItemTraderSearchFilter());
        ATMIconData.init();
    }

    private void registerEventListeners() {
        CommandRegistrationCallback.EVENT.register(CommandLoader::register);
        ServerLifecycleEvents.SERVER_STARTED.register(ServerHook::collectServer);
        ServerLifecycleEvents.SERVER_STOPPED.register(ServerHook::onServerClose);
        ServerHook.addServerStartListener(server -> MoneyUtil.reloadMoneyData());
        ServerHook.addServerStartListener(server -> ATMData.reloadATMData());
        ServerHook.addServerStartListener(server -> ConfigFile.loadServerFiles(ConfigFile.LoadPhase.GAME_START));
        ServerTickEvents.START_SERVER_TICK.register(TraderSaveData::onServerTick);
        ServerTickEvents.START_SERVER_TICK.register(WalletSaveData::onServerTick);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> MoneyUtil.getMoneyData().sendTo(sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ATMData.get().sendTo(sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> BankSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> EjectionSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TraderSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TeamSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> WalletSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> WalletSaveData.OnPlayerDisconnect(handler.field_14140));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> MoneyUtil.onPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> NotificationSaveData.OnPlayerLogin(handler.field_14140, sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> CommandLCAdmin.SendAdminList(sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> SMessageSyncTime.CreatePacket().sendTo(sender));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> SyncedConfigFile.playerJoined(handler.method_32311()));
        LootTableEvents.MODIFY.register(LootManager::onLootTableLoaded);
        EntityDeathCallback.EVENT.register(LootManager::entityDeath);
        MobInitializationCallback.EVENT.register((entity, world, difficulty, spawnReason, entityData, nbt) -> LootManager.onEntitySpawned((class_1309)entity, spawnReason));
        DefaultMoneyDataCollection.EVENT.register(MoneyUtil::initializeDefaultCoins);
        EnchantmentEvents.registerEventListeners();
        LootManager.setup();
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogInfo(String message) {
        LOGGER.info(message);
    }

    public static void LogWarning(String message) {
        LOGGER.warn(message);
    }

    public static void LogWarning(String message, Object ... objects) {
        LOGGER.warn(message, objects);
    }

    public static void LogError(String message, Object ... objects) {
        LOGGER.error(message, objects);
    }

    public static void LogError(String message) {
        LOGGER.error(message);
    }
}

