/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.class_342;

public class TextInputUtil {
    private static final String INTEGER_WHITELIST = "0123456789";
    private static final String FLOAT_WHITELIST = "0123456789.";

    public static boolean isInteger(class_342 textInput) {
        if (textInput == null) {
            return false;
        }
        return TextInputUtil.isInteger(textInput.method_1882());
    }

    public static boolean isInteger(String text) {
        if (text == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int getIntegerValue(class_342 textInput) {
        return TextInputUtil.getIntegerValue(textInput, 0);
    }

    public static int getIntegerValue(class_342 textInput, int defaultValue) {
        if (TextInputUtil.isInteger(textInput)) {
            return Integer.parseInt(textInput.method_1882());
        }
        return defaultValue;
    }

    public static boolean isLong(class_342 textInput) {
        return TextInputUtil.isLong(textInput.method_1882());
    }

    public static boolean isLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long getLongValue(class_342 textInput) {
        return TextInputUtil.getLongValue(textInput, 0);
    }

    public static long getLongValue(class_342 textInput, int defaultValue) {
        if (TextInputUtil.isLong(textInput)) {
            return Long.parseLong(textInput.method_1882());
        }
        return defaultValue;
    }

    public static boolean isFloat(class_342 textInput) {
        return TextInputUtil.isFloat(textInput.method_1882());
    }

    public static boolean isFloat(String text) {
        if (text == null) {
            return false;
        }
        try {
            float f = Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static float getFloatValue(class_342 textInput) {
        return TextInputUtil.getFloatValue(textInput, 0.0f);
    }

    public static float getFloatValue(class_342 textInput, float defaultValue) {
        if (TextInputUtil.isFloat(textInput)) {
            return Float.parseFloat(textInput.method_1882());
        }
        return defaultValue;
    }

    public static boolean isDouble(class_342 textInput) {
        return TextInputUtil.isDouble(textInput.method_1882());
    }

    public static boolean isDouble(String text) {
        if (text == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static double getDoubleValue(class_342 textInput) {
        return TextInputUtil.getDoubleValue(textInput, 0.0);
    }

    public static double getDoubleValue(class_342 textInput, double defaultValue) {
        if (TextInputUtil.isDouble(textInput)) {
            return Double.parseDouble(textInput.method_1882());
        }
        return defaultValue;
    }

    public static void whitelistInteger(class_342 textInput) {
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
    }

    public static void whitelistInteger(class_342 textInput, long minValue, long maxValue) {
        long currentValue;
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
        if (textInput.method_1882().length() > 0 && ((currentValue = TextInputUtil.getLongValue(textInput)) < minValue || currentValue > maxValue)) {
            currentValue = MathUtil.clamp(currentValue, minValue, maxValue);
            textInput.method_1852(Long.toString(currentValue));
        }
    }

    public static void whitelistFloat(class_342 textInput) {
        TextInputUtil.whitelistText(textInput, FLOAT_WHITELIST);
    }

    public static void whitelistText(class_342 textInput, String allowedChars) {
        StringBuilder newText = new StringBuilder(textInput.method_1882());
        for (int i = 0; i < newText.length(); ++i) {
            boolean allowed = false;
            for (int x = 0; x < allowedChars.length() && !allowed; ++x) {
                if (allowedChars.charAt(x) != newText.charAt(i)) continue;
                allowed = true;
            }
            if (allowed) continue;
            newText.deleteCharAt(i--);
        }
        textInput.method_1852(newText.toString());
    }
}

