/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class SlotMachineEntryDisplayWidget
extends class_339 {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 46;
    public final Supplier<SlotMachineTraderData> trader;
    public final Supplier<Integer> index;
    private final class_327 font;
    private static final int ITEM_POSY = 22;

    public SlotMachineEntryDisplayWidget(ScreenPosition pos, Supplier<SlotMachineTraderData> trader, Supplier<Integer> index, class_327 font) {
        this(pos.x, pos.y, trader, index, font);
    }

    public SlotMachineEntryDisplayWidget(int x, int y, Supplier<SlotMachineTraderData> trader, Supplier<Integer> index, class_327 font) {
        super(x, y, 80, 46, (class_2561)EasyText.empty());
        this.trader = trader;
        this.index = index;
        this.font = font;
    }

    @Nullable
    private SlotMachineEntry getEntry() {
        SlotMachineTraderData trader = this.trader.get();
        if (trader != null) {
            int index = this.index.get();
            List<SlotMachineEntry> entries = trader.getValidEntries();
            if (index >= 0 && index < entries.size()) {
                return entries.get(index);
            }
        }
        return null;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        SlotMachineEntry entry = this.getEntry();
        SlotMachineTraderData trader = this.trader.get();
        if (trader != null && entry != null) {
            context.method_51439(this.font, (class_2561)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.entry_label", this.index.get() + 1), this.method_46426(), this.method_46427(), 0x404040, false);
            context.method_51439(this.font, (class_2561)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.odds_label", trader.getOdds(entry.getWeight())), this.method_46426(), this.method_46427() + 12, 0x404040, false);
            for (int i = 0; i < 4; ++i) {
                if (i >= entry.items.size() || entry.items.get(i).method_7960()) continue;
                context.method_51427(entry.items.get(i), this.method_46426() + 18 * i, this.method_46427() + 22);
            }
        }
    }

    private int getItemSlotIndex(double mouseX) {
        int x = (int)mouseX - this.method_46426();
        if (x < 0) {
            return -1;
        }
        int result = x / 18;
        return result >= 4 ? -1 : result;
    }

    public void renderTooltips(class_332 context, int mouseX, int mouseY) {
        List<class_2561> tooltips = this.getTooltipText(mouseX, mouseY);
        if (tooltips != null) {
            context.method_51434(this.font, tooltips, mouseX, mouseY);
        }
    }

    public List<class_2561> getTooltipText(int mouseX, int mouseY) {
        int itemIndex;
        if (!this.field_22764) {
            return null;
        }
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && mouseY >= this.method_46427() + 22 && mouseY < this.method_46427() + 22 + 16 && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0 && itemIndex < entry.items.size()) {
            if (entry.isMoney()) {
                return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.money", entry.getMoneyValue().getComponent("0")));
            }
            class_1799 item = entry.items.get(itemIndex);
            if (!item.method_7960()) {
                return class_437.method_25408((class_310)class_310.method_1551(), (class_1799)item);
            }
        }
        return null;
    }

    protected void method_47399(class_6382 builder) {
    }
}

