/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public abstract class IconData {
    public static final IconData BLANK = new IconData(){

        @Override
        public void render(class_332 gui, class_327 font, int x, int y) {
        }
    };

    @Environment(value=EnvType.CLIENT)
    public abstract void render(class_332 var1, class_327 var2, int var3, int var4);

    public static IconData of(class_1935 item) {
        return IconData.of(new class_1799(item));
    }

    public static IconData of(class_1799 iconStack) {
        return new ItemIcon(iconStack);
    }

    public static IconData of(class_2960 iconImage, int u, int v) {
        return new ImageIcon(iconImage, u, v);
    }

    public static IconData of(class_2561 iconText) {
        return new TextIcon(iconText, 0xFFFFFF);
    }

    public static IconData of(class_2561 iconText, int textColor) {
        return new TextIcon(iconText, textColor);
    }

    public static IconData of(IconData ... icons) {
        return new MultiIcon(Lists.newArrayList((Object[])icons));
    }

    private static class ItemIcon
    extends IconData {
        private final class_1799 iconStack;

        private ItemIcon(class_1799 iconStack) {
            this.iconStack = iconStack;
        }

        @Override
        public void render(class_332 gui, class_327 font, int x, int y) {
            ItemRenderUtil.drawItemStack(gui, font, this.iconStack, x, y);
        }
    }

    private static class ImageIcon
    extends IconData {
        private final class_2960 iconImage;
        private final int iconImageU;
        private final int iconImageV;

        private ImageIcon(class_2960 iconImage, int u, int v) {
            this.iconImage = iconImage;
            this.iconImageU = u;
            this.iconImageV = v;
        }

        @Override
        public void render(class_332 gui, class_327 font, int x, int y) {
            gui.method_25302(this.iconImage, x, y, this.iconImageU, this.iconImageV, 16, 16);
        }
    }

    private static class TextIcon
    extends IconData {
        private final class_2561 iconText;
        private final int textColor;

        private TextIcon(class_2561 iconText, int textColor) {
            this.iconText = iconText;
            this.textColor = textColor;
        }

        @Override
        public void render(class_332 gui, class_327 font, int x, int y) {
            int xPos = x + 8 - font.method_1727(this.iconText.getString()) / 2;
            Objects.requireNonNull(font);
            int yPos = y + (16 - 9) / 2;
            gui.method_51433(font, this.iconText.getString(), xPos, yPos, this.textColor, true);
        }
    }

    private static class MultiIcon
    extends IconData {
        private final List<IconData> icons;

        private MultiIcon(List<IconData> icons) {
            this.icons = icons;
        }

        @Override
        public void render(class_332 gui, class_327 font, int x, int y) {
            for (IconData icon : this.icons) {
                icon.render(gui, font, x, y);
            }
        }
    }
}

