/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.InteractionConsumer;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class TradeButtonArea
extends class_339
implements ScrollBarWidget.IScrollable {
    public static final Function<TradeData, Boolean> FILTER_VALID = TradeData::isValid;
    public static final Function<TradeData, Boolean> FILTER_ANY = trade -> true;
    private final ITraderSource traderSource;
    private final Function<TraderData, TradeContext> getContext;
    private BiFunction<TraderData, TradeData, Boolean> isSelected = (trader, trade) -> false;
    private InteractionConsumer interactionConsumer = null;
    private final List<TradeButton> allButtons = new ArrayList<TradeButton>();
    private final class_327 font;
    private final Consumer<class_339> addWidget;
    private final Consumer<TradeButton> removeButton;
    private final BiConsumer<TraderData, TradeData> onPress;
    private final Function<TradeData, Boolean> tradeFilter;
    private int scroll = 0;
    ScrollBarWidget scrollBar;
    private int scrollBarXOffset = 0;

    public void setSelectionDefinition(@NotNull BiFunction<TraderData, TradeData, Boolean> isSelected) {
        this.isSelected = isSelected;
    }

    public void setInteractionConsumer(InteractionConsumer consumer) {
        this.interactionConsumer = consumer;
    }

    public ScrollBarWidget getScrollBar() {
        return this.scrollBar;
    }

    public int getMinAvailableWidth() {
        return this.scrollBarXOffset < 0 ? this.field_22758 + this.scrollBarXOffset : this.field_22758;
    }

    public int getAvailableWidth() {
        return this.scrollBar.visible() ? (this.scrollBarXOffset < 0 ? this.field_22758 + this.scrollBarXOffset : this.field_22758) : this.field_22758;
    }

    public TradeButtonArea(ITraderSource traderSource, Function<TraderData, TradeContext> getContext, int x, int y, int width, int height, Consumer<class_339> addWidget, Consumer<TradeButton> removeButton, BiConsumer<TraderData, TradeData> onPress, Function<TradeData, Boolean> tradeFilter) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.traderSource = traderSource;
        this.getContext = getContext;
        this.addWidget = addWidget;
        this.removeButton = removeButton;
        this.onPress = onPress;
        this.tradeFilter = tradeFilter;
        class_310 mc = class_310.method_1551();
        this.font = mc.field_1772;
    }

    public void init() {
        this.init(-9, 0, this.field_22759 - 5);
    }

    public void init(int scrollBarXOffset, int scrollBarYOffset, int scrollBarHeight) {
        this.scrollBarXOffset = scrollBarXOffset;
        this.scrollBar = new ScrollBarWidget(this.method_46426() + this.field_22758 + scrollBarXOffset, this.method_46427() + scrollBarYOffset, scrollBarHeight, this);
        this.addWidget.accept(this.scrollBar);
        this.resetButtons();
        this.tick();
    }

    public TraderData getTrader(int traderIndex) {
        if (this.traderSource == null) {
            return null;
        }
        List<TraderData> traders = this.traderSource.getTraders();
        if (traderIndex < 0 || traderIndex >= traders.size()) {
            return null;
        }
        return traders.get(traderIndex);
    }

    public List<List<Pair<TraderData, TradeData>>> getTradesInRows() {
        ArrayList<List<Pair<TraderData, TradeData>>> result = new ArrayList<List<Pair<TraderData, TradeData>>>();
        List<TraderData> traders = this.traderSource.getTraders();
        int currentRowWidth = 0;
        ArrayList<Pair> currentRow = new ArrayList<Pair>();
        for (TraderData trader : traders) {
            TradeContext context = this.getContext.apply(trader);
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (!this.tradeFilter.apply(tradeData).booleanValue()) continue;
                int tradeWidth = tradeData.tradeButtonWidth(context);
                if (currentRowWidth + tradeWidth > this.getMinAvailableWidth() && currentRow.size() > 0) {
                    result.add(currentRow);
                    currentRow = new ArrayList();
                    currentRowWidth = 0;
                }
                currentRow.add(Pair.of((Object)trader, (Object)tradeData));
                currentRowWidth += tradeWidth;
            }
        }
        result.add(currentRow);
        return result;
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int displayIndex) {
        return this.getTradeAndTrader(this.scroll, displayIndex);
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int assumedScroll, int displayIndex) {
        if (this.traderSource == null) {
            return Pair.of(null, null);
        }
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        for (int r = assumedScroll; r < rows.size(); ++r) {
            List<Pair<TraderData, TradeData>> row = rows.get(r);
            for (Pair<TraderData, TradeData> traderDataTradeDataPair : row) {
                if (displayIndex <= 0) {
                    return traderDataTradeDataPair;
                }
                --displayIndex;
            }
        }
        return Pair.of(null, null);
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.validTrades() <= 0) {
            int textWidth = this.font.method_27525((class_5348)class_2561.method_43471((String)"gui.lightmanscurrency.notrades"));
            class_5250 class_52502 = class_2561.method_43471((String)"gui.lightmanscurrency.notrades");
            int n = this.method_46426() + this.field_22758 / 2 - textWidth / 2;
            int n2 = this.method_46427() + this.field_22759 / 2;
            Objects.requireNonNull(this.font);
            gui.method_51439(this.font, (class_2561)class_52502, n, n2 - 9 / 2, 0x404040, false);
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tick() {
        this.validateScroll();
        if (this.allButtons.size() < this.fittableLines()) {
            this.resetButtons();
        } else {
            this.repositionButtons();
        }
    }

    private void validateScroll() {
        if (this.canScrollDown()) {
            return;
        }
        int oldScroll = this.scroll;
        this.scroll = MathUtil.clamp(this.scroll, 0, this.getMaxScroll());
        if (this.scroll != oldScroll) {
            this.repositionButtons();
        }
    }

    private void resetButtons() {
        this.allButtons.forEach(this.removeButton);
        this.allButtons.clear();
        int requiredButtons = this.requiredButtons();
        int i = 0;
        while (i < requiredButtons) {
            int di = i++;
            TradeButton newButton = new TradeButton(() -> this.getContext.apply((TraderData)this.getTradeAndTrader(di).getFirst()), () -> (TradeData)this.getTradeAndTrader(di).getSecond(), button -> this.OnTraderPress(di));
            this.addWidget.accept((class_339)newButton);
            this.allButtons.add(newButton);
        }
        this.repositionButtons();
    }

    private int validTrades() {
        if (this.traderSource == null) {
            return 0;
        }
        int count = 0;
        List<TraderData> traders = this.traderSource.getTraders();
        for (TraderData trader : traders) {
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (tradeData == null || !this.tradeFilter.apply(tradeData).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    private int requiredButtons() {
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        int count = 0;
        int lines = this.fittableLines();
        for (int r = this.scroll; r < rows.size() && r < this.scroll + lines; ++r) {
            count += rows.get(r).size();
        }
        return count;
    }

    private int fittableLines() {
        return this.field_22759 / 22;
    }

    private void repositionButtons() {
        int displayIndex = 0;
        int yOffset = 0;
        int fittableLines = this.fittableLines();
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows();
        for (int line = 0; line < fittableLines && line + this.scroll < rows.size(); ++line) {
            int spacing;
            List<Pair<TraderData, TradeData>> row = rows.get(line + this.scroll);
            int visibleButtons = 0;
            int totalWidth = 0;
            for (Pair<TraderData, TradeData> trade : row) {
                if (trade.getFirst() == null || trade.getSecond() == null) continue;
                TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                ++visibleButtons;
                totalWidth += ((TradeData)trade.getSecond()).tradeButtonWidth(context);
            }
            int xOffset = spacing = (this.getAvailableWidth() - totalWidth) / (visibleButtons + 1);
            for (Pair<TraderData, TradeData> trade : row) {
                TradeButton button = this.allButtons.get(displayIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                    button.method_48229(this.method_46426() + xOffset, this.method_46427() + yOffset);
                    button.field_22764 = true;
                    button.field_22763 = this.isSelected.apply((TraderData)trade.getFirst(), (TradeData)trade.getSecond()) == false;
                    xOffset += ((TradeData)trade.getSecond()).tradeButtonWidth(context) + spacing;
                } else {
                    button.field_22764 = false;
                }
                ++displayIndex;
            }
            yOffset += 22;
        }
        for (int i = displayIndex; i < this.allButtons.size(); ++i) {
            this.allButtons.get((int)i).field_22764 = false;
        }
    }

    private void OnTraderPress(int displayIndex) {
        if (this.onPress != null) {
            Pair<TraderData, TradeData> data = this.getTradeAndTrader(displayIndex);
            this.onPress.accept((TraderData)data.getFirst(), (TradeData)data.getSecond());
        }
    }

    public void renderTraderName(class_332 gui, int x, int y, int maxWidth, boolean renderTitle) {
        if (this.traderSource == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        for (TraderData trader : this.traderSource.getTraders()) {
            if (text.length() == 0) {
                text = new StringBuilder(renderTitle ? trader.getTitle().getString() : trader.getName().getString());
                continue;
            }
            text.append(class_2561.method_43471((String)"gui.lightmanscurrency.trading.listseperator").getString()).append(renderTitle ? trader.getTitle().getString() : trader.getName().getString());
        }
        gui.method_51439(this.font, TextRenderUtil.fitString(text.toString(), maxWidth), x, y, 0x404040, false);
    }

    public void renderTooltips(class_332 gui, int nameX, int nameY, int nameWidth, int mouseX, int mouseY) {
        for (TradeButton button : this.allButtons) {
            button.renderTooltips(gui, this.font, mouseX, mouseY);
        }
        this.renderTraderNameTooltip(gui, nameX, nameY, nameWidth, mouseX, mouseY);
    }

    public void renderTraderNameTooltip(class_332 gui, int x, int y, int maxWidth, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + maxWidth && mouseY >= y) {
            Objects.requireNonNull(this.font);
            if (mouseY < y + 9) {
                ArrayList<class_5250> tooltips = new ArrayList<class_5250>();
                if (this.traderSource == null) {
                    return;
                }
                for (TraderData trader : this.traderSource.getTraders()) {
                    tooltips.add(trader.getTitle());
                }
                if (tooltips.size() == 0) {
                    return;
                }
                gui.method_51434(this.font, tooltips, mouseX, mouseY);
            }
        }
    }

    private boolean canScrollDown() {
        return this.canScrollDown(this.scroll);
    }

    private boolean canScrollDown(int assumedScroll) {
        return this.getTradesInRows().size() - assumedScroll > this.fittableLines();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            this.resetButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
            this.resetButtons();
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.allButtons.size(); ++i) {
            TradeButton b = this.allButtons.get(i);
            if (!b.method_25405(mouseX, mouseY)) continue;
            Pair<TraderData, TradeData> traderPair = this.getTradeAndTrader(i);
            TradeContext context = this.getContext.apply((TraderData)traderPair.getFirst());
            if (context.isStorageMode) {
                if (this.interactionConsumer == null) continue;
                b.onInteractionClick((int)mouseX, (int)mouseY, button, this.interactionConsumer);
                return true;
            }
            return b.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public void method_47399(class_6382 builder) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        if (newScroll == this.scroll) {
            return;
        }
        this.scroll = MathUtil.clamp(newScroll, 0, this.getMaxScroll());
        this.resetButtons();
    }

    @Override
    public int getMaxScroll() {
        int s = 0;
        while (this.canScrollDown(s)) {
            ++s;
        }
        return s;
    }
}

