/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6382;

public class TimeInputWidget
extends class_339 {
    private final List<TimeUtil.TimeUnit> relevantUnits;
    private final int spacing;
    public long maxDuration = Long.MAX_VALUE;
    public long minDuration = 0L;
    private final Consumer<TimeUtil.TimeData> timeConsumer;
    long days = 0L;
    long hours = 0L;
    long minutes = 0L;
    long seconds = 0L;
    private List<class_4185> buttons = new ArrayList<class_4185>();

    public TimeUtil.TimeData getTime() {
        return new TimeUtil.TimeData(this.days, this.hours, this.minutes, this.seconds);
    }

    public TimeInputWidget(int x, int y, int spacing, TimeUtil.TimeUnit largestUnit, TimeUtil.TimeUnit smallestUnit, Consumer<class_339> widgetAdder, Consumer<TimeUtil.TimeData> timeConsumer) {
        super(x, y, 0, 0, (class_2561)class_2561.method_43473());
        this.timeConsumer = timeConsumer;
        this.relevantUnits = this.getRelevantUnits(largestUnit, smallestUnit);
        this.spacing = spacing;
        for (int i = 0; i < this.relevantUnits.size(); ++i) {
            TimeUtil.TimeUnit unit = this.relevantUnits.get(i);
            int xPos = this.method_46426() + (20 + this.spacing) * i;
            PlainButton addButton = new PlainButton(xPos, this.method_46427(), 20, 10, b -> this.addTime(unit), CoinValueInput.GUI_TEXTURE, 0, 69);
            PlainButton removeButton = new PlainButton(xPos, this.method_46427() + 23, 20, 10, b -> this.removeTime(unit), CoinValueInput.GUI_TEXTURE, 20, 69);
            widgetAdder.accept((class_339)addButton);
            widgetAdder.accept((class_339)removeButton);
            this.buttons.add(addButton);
            this.buttons.add(removeButton);
        }
    }

    public void setTime(long milliseconds) {
        this.setTimeInternal(milliseconds);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    public void setTime(TimeUtil.TimeData time) {
        this.setTimeInternal(time);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    public void setTime(long days, long hours, long minutes, long seconds) {
        this.setTimeInternal(days, hours, minutes, seconds);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void setTimeInternal(long milliseconds) {
        this.setTimeInternal(new TimeUtil.TimeData(milliseconds));
    }

    private void setTimeInternal(TimeUtil.TimeData time) {
        this.setTimeInternal(time.days, time.hours, time.minutes, time.seconds);
    }

    private void setTimeInternal(long days, long hours, long minutes, long seconds) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        if (!this.validUnit(TimeUtil.TimeUnit.DAY)) {
            this.hours += this.days * 24L;
            this.days = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.HOUR)) {
            this.minutes += this.hours * 60L;
            this.hours = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.MINUTE)) {
            this.seconds += this.minutes * 60L;
            this.minutes = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.SECOND)) {
            this.seconds = 0L;
        }
    }

    private boolean validUnit(TimeUtil.TimeUnit unit) {
        return this.relevantUnits.contains((Object)unit);
    }

    private void addTime(TimeUtil.TimeUnit unit) {
        switch (unit) {
            case DAY: {
                ++this.days;
                break;
            }
            case HOUR: {
                ++this.hours;
                if (this.hours < 24L || !this.validUnit(TimeUtil.TimeUnit.DAY)) break;
                this.days += this.hours / 24L;
                this.hours %= 24L;
                break;
            }
            case MINUTE: {
                ++this.minutes;
                if (this.minutes < 60L || !this.validUnit(TimeUtil.TimeUnit.HOUR)) break;
                this.hours += this.minutes / 60L;
                this.minutes %= 60L;
                break;
            }
            case SECOND: {
                ++this.seconds;
                if (this.seconds < 60L || !this.validUnit(TimeUtil.TimeUnit.SECOND)) break;
                this.minutes += this.seconds / 60L;
                this.seconds %= 60L;
            }
        }
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void removeTime(TimeUtil.TimeUnit unit) {
        this.removeTimeInternal(unit);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void removeTimeInternal(TimeUtil.TimeUnit unit) {
        switch (unit) {
            case DAY: {
                this.days = Math.max(0L, this.days - 1L);
                break;
            }
            case HOUR: {
                --this.hours;
                if (this.hours < 0L && this.days > 0L) {
                    this.removeTimeInternal(TimeUtil.TimeUnit.DAY);
                    this.hours += 24L;
                    break;
                }
                this.hours = 0L;
                break;
            }
            case MINUTE: {
                --this.minutes;
                if (this.minutes < 0L && (this.hours > 0L || this.days > 0L)) {
                    this.removeTimeInternal(TimeUtil.TimeUnit.HOUR);
                    this.minutes += 60L;
                    break;
                }
                this.minutes = 0L;
                break;
            }
            case SECOND: {
                --this.seconds;
                if (this.seconds >= 0L || this.minutes <= 0L && this.hours <= 0L && this.days <= 0L) break;
                this.removeTimeInternal(TimeUtil.TimeUnit.MINUTE);
                this.seconds += 60L;
            }
        }
    }

    private void validateTime() {
        long duration = this.getTime().miliseconds;
        if (duration > this.maxDuration) {
            this.setTimeInternal(this.maxDuration);
        }
        if (duration < this.minDuration) {
            this.setTimeInternal(this.minDuration);
        }
    }

    private List<TimeUtil.TimeUnit> getRelevantUnits(TimeUtil.TimeUnit largestUnit, TimeUtil.TimeUnit smallestUnit) {
        ArrayList<TimeUtil.TimeUnit> results = new ArrayList<TimeUtil.TimeUnit>();
        List<TimeUtil.TimeUnit> units = TimeUtil.TimeUnit.UNITS_LARGE_TO_SMALL;
        int startIndex = units.indexOf((Object)largestUnit);
        if (startIndex < 0) {
            throw new RuntimeException("TimeUnit '" + largestUnit + "' could not be found on the TimeUnit list!");
        }
        for (int i = startIndex; i < units.size(); ++i) {
            TimeUtil.TimeUnit unit = units.get(i);
            results.add(unit);
            if (unit == smallestUnit) break;
        }
        return results;
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        for (class_4185 b : this.buttons) {
            b.field_22763 = this.field_22763;
            b.field_22764 = this.field_22764;
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    protected void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.relevantUnits.size(); ++i) {
            TextRenderUtil.drawCenteredText(gui, this.getTime().getUnitString(this.relevantUnits.get(i), true), this.method_46426() + (20 + this.spacing) * i + 10, this.method_46427() + 12, 0xFFFFFF);
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void removeChildren(Consumer<class_339> remover) {
        for (class_4185 b : this.buttons) {
            remover.accept((class_339)b);
        }
    }

    public void method_47399(class_6382 builder) {
    }
}

