/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6382;

public class TeamSelectWidget
extends class_339 {
    private final int rows;
    private final TeamButton.Size size;
    private final java.util.function.Supplier<List<Team>> teamSource;
    private final java.util.function.Supplier<Team> selectedTeam;
    private final Consumer<Integer> onPress;
    private List<TeamButton> teamButtons = Lists.newArrayList();
    private int scroll = 0;

    public TeamSelectWidget(int x, int y, int rows, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        this(x, y, rows, TeamButton.Size.WIDE, teamSource, selectedTeam, onPress);
    }

    public TeamSelectWidget(int x, int y, int rows, TeamButton.Size size, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        super(x, y, size.width, 20 * rows, (class_2561)class_2561.method_43473());
        this.rows = rows;
        this.size = size;
        this.teamSource = teamSource;
        this.selectedTeam = selectedTeam;
        this.onPress = onPress;
    }

    public void init(Consumer<class_4185> addButton, class_327 font) {
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            TeamButton button = new TeamButton(this.method_46426(), this.method_46427() + i * 20, this.size, this::onTeamSelect, font, (Supplier<Team>)((Supplier)() -> this.getTeam(index)), (Supplier<Boolean>)((Supplier)() -> this.isSelected(index)));
            this.teamButtons.add(button);
            addButton.accept(button);
        }
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.teamButtons.forEach(b -> {
            b.field_22764 = this.field_22764;
        });
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    protected void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        gui.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private Team getTeam(int index) {
        List<Team> teamList = this.teamSource.get();
        this.validateScroll(teamList.size());
        if ((index += this.scroll) >= 0 && index < teamList.size()) {
            return teamList.get(index);
        }
        return null;
    }

    private boolean isSelected(int index) {
        Team team = this.getTeam(index);
        if (team == null) {
            return false;
        }
        return team == this.selectedTeam.get();
    }

    private void validateScroll(int teamListSize) {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.maxScroll(teamListSize));
    }

    private int maxScroll(int teamListSize) {
        return MathUtil.clamp(teamListSize - this.rows, 0, Integer.MAX_VALUE);
    }

    private boolean canScrollDown() {
        return this.scroll < this.maxScroll(this.teamSource.get().size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.field_22764) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    private void onTeamSelect(class_4185 button) {
        int index = this.teamButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.onPress.accept(this.scroll + index);
    }

    public void method_47399(class_6382 builder) {
    }

    protected boolean method_25351(int button) {
        return false;
    }

    public void method_25354(class_1144 soundManager) {
    }
}

