/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public class ScrollTextDisplay
extends class_339 {
    private class_327 font;
    private final Supplier<List<? extends class_2561>> textSource;
    public boolean invertText = false;
    public int backgroundColor = -16777216;
    public int textColor = 0xFFFFFF;
    private int columnCount = 1;
    private int scroll = 0;

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = MathUtil.clamp(columnCount, 1, Integer.MAX_VALUE);
    }

    public ScrollTextDisplay(int x, int y, int width, int height, class_327 font, Supplier<List<? extends class_2561>> textSource) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
        this.textSource = textSource;
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        int rowHeight;
        gui.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.backgroundColor);
        List text = (List)this.textSource.get();
        this.validateScroll(text.size());
        int i = this.getStartingIndex(text.size());
        int columnWidth = this.getColumnWidth();
        int bottom = this.method_46427() + this.field_22759;
        for (int yPos = this.method_46427() + 2; yPos < bottom && i >= 0 && i < text.size(); yPos += rowHeight) {
            rowHeight = 0;
            for (int col = 0; col < this.columnCount && i >= 0 && i < text.size(); ++col) {
                int xPos = this.getXPos(col);
                class_2561 thisText = (class_2561)text.get(i);
                int thisHeight = this.font.method_1713(thisText.getString(), columnWidth);
                if (yPos + thisHeight < bottom) {
                    gui.method_51440(this.font, (class_5348)thisText, xPos, yPos, columnWidth, this.textColor);
                }
                if (thisHeight > rowHeight) {
                    rowHeight = thisHeight;
                }
                i = this.invertText ? i - 1 : i + 1;
            }
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void validateScroll(int listSize) {
        if (this.scroll * this.columnCount >= listSize) {
            this.scroll = MathUtil.clamp(this.scroll, 0, listSize / this.columnCount - 1);
        }
    }

    private int getStartingIndex(int listSize) {
        return this.invertText ? listSize - 1 - this.scroll * this.columnCount : this.scroll * this.columnCount;
    }

    private int getColumnWidth() {
        return (this.field_22758 - 4) / this.columnCount;
    }

    private int getXPos(int column) {
        int columnSpacing = this.field_22758 / this.columnCount;
        return this.method_46426() + 2 + column * columnSpacing;
    }

    private boolean canScrollDown() {
        return this.scroll < ((List)this.textSource.get()).size();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.field_22764) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    public void method_47399(class_6382 builder) {
    }
}

