/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.DropdownButton;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_6382;

public class DropdownWidget
extends class_339 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/dropdown.png");
    public static final int HEIGHT = 12;
    boolean open = false;
    int currentlySelected;
    private final class_327 font;
    private final List<class_2561> options;
    private final Consumer<Integer> onSelect;
    private final Function<Integer, Boolean> optionActive;
    List<class_4185> optionButtons = new ArrayList<class_4185>();

    public DropdownWidget(int x, int y, int width, class_327 font, int selected, Consumer<Integer> onSelect, Function<class_4185, class_4185> addButton, class_2561 ... options) {
        this(x, y, width, font, selected, onSelect, (Integer index) -> true, addButton, options);
    }

    public DropdownWidget(int x, int y, int width, class_327 font, int selected, Consumer<Integer> onSelect, Function<class_4185, class_4185> addButton, List<class_2561> options) {
        this(x, y, width, font, selected, onSelect, (Integer index) -> true, addButton, options);
    }

    public DropdownWidget(int x, int y, int width, class_327 font, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Function<class_4185, class_4185> addButton, class_2561 ... options) {
        this(x, y, width, font, selected, onSelect, optionActive, addButton, Lists.newArrayList((Object[])options));
    }

    public DropdownWidget(int x, int y, int width, class_327 font, int selected, Consumer<Integer> onSelect, Function<Integer, Boolean> optionActive, Function<class_4185, class_4185> addButton, List<class_2561> options) {
        super(x, y, width, 12, (class_2561)class_2561.method_43473());
        this.font = font;
        this.options = options;
        this.currentlySelected = MathUtil.clamp(selected, 0, this.options.size() - 1);
        this.onSelect = onSelect;
        this.optionActive = optionActive;
        this.init(addButton);
    }

    private void init(Function<class_4185, class_4185> addButton) {
        this.optionButtons = new ArrayList<class_4185>();
        for (int i = 0; i < this.options.size(); ++i) {
            int yPos = this.method_46427() + 12 + i * 12;
            this.optionButtons.add(addButton.apply(new DropdownButton(this.method_46426(), yPos, this.field_22758, this.font, this.options.get(i), this::OnSelect)));
            this.optionButtons.get((int)i).field_22764 = this.open;
        }
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        int xPart;
        int offset;
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int n = offset = this.field_22762 ? this.field_22759 : 0;
        if (!this.field_22763) {
            gui.method_51422(0.5f, 0.5f, 0.5f, 1.0f);
        }
        gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427(), 0, offset, 2, 12);
        for (int xOffset = 0; xOffset < this.field_22758 - 14; xOffset += xPart) {
            xPart = Math.min(this.field_22758 - 14 - xOffset, 244);
            gui.method_25302(GUI_TEXTURE, this.method_46426() + 2 + xOffset, this.method_46427(), 2, offset, xPart, 12);
        }
        gui.method_25302(GUI_TEXTURE, this.method_46426() + this.field_22758 - 12, this.method_46427(), 244, offset, 12, 12);
        gui.method_51433(this.font, this.fitString(this.options.get(this.currentlySelected).getString()), this.method_46426() + 2, this.method_46427() + 2, 0x404040, false);
        if (this.open) {
            for (int i = 0; i < this.optionButtons.size(); ++i) {
                this.optionButtons.get((int)i).field_22763 = this.optionActive.apply(i) != false && i != this.currentlySelected;
            }
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int click) {
        if (this.field_22763 && this.field_22764) {
            if (this.method_25361(mouseX, mouseY) && this.method_25351(click)) {
                this.method_25354(class_310.method_1551().method_1483());
                this.open = !this.open;
                this.optionButtons.forEach(button -> {
                    button.field_22764 = this.open;
                });
                return true;
            }
            if (this.open) {
                this.open = false;
                this.optionButtons.forEach(button -> {
                    button.field_22764 = false;
                });
            }
            return false;
        }
        return false;
    }

    private void OnSelect(class_4185 button) {
        int index = this.optionButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.currentlySelected = index;
        this.onSelect.accept(index);
        this.open = false;
        this.optionButtons.forEach(b -> {
            b.field_22764 = false;
        });
    }

    public void method_47399(class_6382 builder) {
    }

    private String fitString(String text) {
        if (this.font.method_1727(text) <= this.field_22758 - 14) {
            return text;
        }
        while (this.font.method_1727(text + "...") > this.field_22758 - 14 && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }
}

