/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class DirectionalSettingsWidget {
    public static final class_2960 BLOCK_SIDE_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/blocksides.png");
    private static final List<class_2350> DIRECTIONS = Lists.newArrayList((Object[])new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034});
    private static final int SPACING = 20;
    private final Function<class_2350, Boolean> currentValueSource;
    private final Consumer<class_2350> onPress;
    List<PlainButton> directionButtons;
    public boolean visible = true;

    public DirectionalSettingsWidget(int x, int y, Function<class_2350, Boolean> currentValueSource, ImmutableList<class_2350> ignoreSides, Consumer<class_2350> onPress, Consumer<class_4185> addButton) {
        this.currentValueSource = currentValueSource;
        this.onPress = onPress;
        this.directionButtons = Lists.newArrayListWithCapacity((int)class_2350.values().length);
        for (int i = 0; i < DIRECTIONS.size(); ++i) {
            class_2350 side = DIRECTIONS.get(i);
            boolean value = this.currentValueSource.apply(side);
            PlainButton button = new PlainButton(x + this.getSidePosX(side), y + this.getSidePosY(side), 16, 16, this::onButtonPress, BLOCK_SIDE_TEXTURE, this.getSideU(side), value ? 32 : 0);
            button.field_22764 = !ignoreSides.contains((Object)side);
            this.directionButtons.add(button);
            addButton.accept(button);
        }
    }

    public void renderTooltips(class_332 gui, int mouseX, int mouseY, class_327 font) {
        for (class_2350 side : class_2350.values()) {
            PlainButton button = this.getButton(side);
            if (!button.method_25405(mouseX, mouseY)) continue;
            gui.method_51438(font, (class_2561)InputTraderData.getFacingName(side), mouseX, mouseY);
        }
    }

    private int getSidePosX(class_2350 side) {
        switch (side) {
            case field_11036: 
            case field_11035: 
            case field_11033: {
                return 20;
            }
            case field_11034: 
            case field_11043: {
                return 40;
            }
        }
        return 0;
    }

    private int getSidePosY(class_2350 side) {
        switch (side) {
            case field_11035: 
            case field_11034: 
            case field_11039: {
                return 20;
            }
            case field_11033: 
            case field_11043: {
                return 40;
            }
        }
        return 0;
    }

    private int getSideU(class_2350 side) {
        return side.method_10146() * 16;
    }

    public PlainButton getButton(class_2350 direction) {
        return this.directionButtons.get(direction.method_10146());
    }

    public void tick() {
        for (class_2350 side : class_2350.values()) {
            PlainButton button = this.getButton(side);
            button.setResource(BLOCK_SIDE_TEXTURE, this.getSideU(side), this.currentValueSource.apply(side) != false ? 32 : 0);
        }
    }

    private void onButtonPress(class_4185 button) {
        int index = this.directionButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.onPress.accept(class_2350.method_10143((int)index));
    }
}

