/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankInteraction;
import net.minecraft.class_1263;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class BankAccountWidget {
    public static final int MIN_WIDTH = 100;
    public static final int HEIGHT = 109;
    public static final int BUTTON_WIDTH = 70;
    private final IBankAccountWidget parent;
    private CoinValueInput amountSelection;
    class_4185 buttonDeposit;
    class_4185 buttonWithdraw;
    int y;
    int spacing;
    public boolean allowEmptyDeposits = true;

    public CoinValueInput getAmountSelection() {
        return this.amountSelection;
    }

    public BankAccountWidget(int y, IBankAccountWidget parent) {
        this(y, parent, 0);
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, int spacing) {
        this.parent = parent;
        this.y = y;
        this.spacing = spacing;
        int screenMiddle = this.parent.getScreen().field_22789 / 2;
        this.amountSelection = this.parent.addCustomWidget(new CoinValueInput(screenMiddle - 88, this.y, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.bank.amounttip"), CoinValue.EMPTY, this.parent.getFont(), value -> {}, this.parent::addCustomWidget));
        this.amountSelection.allowFreeToggle = false;
        this.amountSelection.init();
        this.buttonDeposit = this.parent.addCustomWidget(new VanillaButton(screenMiddle - 5 - 70, this.y + 69 + 5 + spacing, 70, 20, (class_2561)class_2561.method_43471((String)"gui.button.bank.deposit"), this::OnDeposit));
        this.buttonWithdraw = this.parent.addCustomWidget(new VanillaButton(screenMiddle + 5, this.y + 69 + 5 + spacing, 70, 20, (class_2561)class_2561.method_43471((String)"gui.button.bank.withdraw"), this::OnWithdraw));
        this.buttonWithdraw.field_22763 = false;
        this.buttonDeposit.field_22763 = false;
    }

    public void renderInfo(class_332 gui) {
        this.renderInfo(gui, 0);
    }

    public void renderInfo(class_332 gui, int yOffset) {
        int screenMiddle = this.parent.getScreen().field_22789 / 2;
        class_327 font = this.parent.getFont();
        class_5250 balanceComponent = this.parent.getBankAccount() == null ? class_2561.method_43471((String)"gui.lightmanscurrency.bank.null") : class_2561.method_43469((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{this.parent.getBankAccount().getCoinStorage().getString("0")});
        int offset = font.method_1727(balanceComponent.getString()) / 2;
        gui.method_51439(this.parent.getFont(), (class_2561)balanceComponent, screenMiddle - offset, this.y + 69 + 30 + this.spacing + yOffset, 0x404040, false);
    }

    public void tick() {
        this.amountSelection.tick();
        if (this.parent.getBankAccount() == null) {
            this.buttonWithdraw.field_22763 = false;
            this.buttonDeposit.field_22763 = false;
        } else {
            this.buttonDeposit.field_22763 = MoneyUtil.getValue(this.parent.getCoinAccess()) > 0L && (this.allowEmptyDeposits || this.amountSelection.getCoinValue().getRawValue() > 0L);
            this.buttonWithdraw.field_22763 = this.amountSelection.getCoinValue().getRawValue() > 0L;
        }
    }

    private void OnDeposit(class_4185 button) {
        new CMessageBankInteraction(true, this.amountSelection.getCoinValue()).sendToServer();
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    private void OnWithdraw(class_4185 button) {
        new CMessageBankInteraction(false, this.amountSelection.getCoinValue()).sendToServer();
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    public static interface IBankAccountWidget {
        public <T extends class_364 & class_4068> T addCustomWidget(T var1);

        public class_327 getFont();

        public class_437 getScreen();

        public BankAccount getBankAccount();

        public class_1263 getCoinAccess();
    }
}

