/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageCreateTeam;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TeamSelectionTab
extends TeamTab {
    public static final TeamSelectionTab INSTANCE = new TeamSelectionTab();
    TeamSelectWidget teamSelection;
    List<Team> teamList = Lists.newArrayList();
    class_342 newTeamName;
    class_4185 buttonCreateTeam;

    private TeamSelectionTab() {
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8407);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.team.selection");
    }

    @Override
    public boolean allowViewing(class_1657 player, Team team) {
        return true;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.refreshTeamList();
        this.teamSelection = screen.addRenderableTabWidget(new TeamSelectWidget(screen.guiLeft() + 10, screen.guiTop() + 20, 5, () -> this.teamList, this::getActiveTeam, this::selectTeamButton));
        this.teamSelection.init(screen::addRenderableTabWidget, this.getFont());
        this.newTeamName = screen.addRenderableTabWidget(new class_342(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 140, 160, 20, (class_2561)class_2561.method_43473()));
        this.newTeamName.method_1880(32);
        this.buttonCreateTeam = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 120, screen.guiTop() + 165, 60, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.create"), this::createTeam));
        this.buttonCreateTeam.field_22763 = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TeamManagerScreen screen = this.getScreen();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.team.select"), screen.guiLeft() + 20, screen.guiTop() + 10, 0x404040, false);
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.team.create"), screen.guiLeft() + 20, screen.guiTop() + 130, 0x404040, false);
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonCreateTeam.field_22763 = !this.newTeamName.method_1882().isBlank();
    }

    @Override
    public void closeTab() {
    }

    private void selectTeamButton(int teamIndex) {
        Team team = this.getTeam(teamIndex);
        if (team != null) {
            if (this.getScreen().getActiveTeam() == team) {
                this.getScreen().setActiveTeam(-1L);
            } else {
                this.getScreen().setActiveTeam(team.getID());
            }
        }
    }

    private void createTeam(class_4185 button) {
        if (this.newTeamName.method_1882().isEmpty()) {
            return;
        }
        new CMessageCreateTeam(this.newTeamName.method_1882()).sendToServer();
        this.newTeamName.method_1852("");
    }
}

