/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core;

import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.Objects;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class NotificationTab
extends SettingsTab {
    public static final NotificationTab INSTANCE = new NotificationTab();
    PlainButton buttonToggleNotifications;
    PlainButton buttonToggleChatNotifications;
    class_4185 buttonToggleTeamLevel;

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8634);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.notifications");
    }

    private NotificationTab() {
    }

    @Override
    public boolean canOpen() {
        return this.hasPermissions("transferOwnership");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.buttonToggleNotifications = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 35, 10, 10, this::ToggleNotifications, TraderSettingsScreen.GUI_TEXTURE, 10, 200));
        this.buttonToggleChatNotifications = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 55, 10, 10, this::ToggleChatNotifications, TraderSettingsScreen.GUI_TEXTURE, 10, 200));
        int n = screen.guiLeft() + 20;
        int n2 = screen.guiTop() + 80;
        Objects.requireNonNull(screen);
        this.buttonToggleTeamLevel = screen.addRenderableTabWidget(new VanillaButton(n, n2, 200 - 40, 20, (class_2561)class_2561.method_43473(), this::ToggleTeamNotificationLevel));
        this.tick();
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        TraderData trader = this.getTrader();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.notifications.enabled"), screen.guiLeft() + 32, screen.guiTop() + 35, 0x404040, false);
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.notifications.chat"), screen.guiLeft() + 32, screen.guiTop() + 55, 0x404040, false);
        this.buttonToggleTeamLevel.field_22764 = trader.getOwner().hasTeam();
        if (this.buttonToggleTeamLevel.field_22764) {
            class_5250 message = class_2561.method_43469((String)"gui.button.lightmanscurrency.team.bank.notifications", (Object[])new Object[]{class_2561.method_43471((String)("gui.button.lightmanscurrency.team.bank.limit." + trader.teamNotificationLevel()))});
            this.buttonToggleTeamLevel.method_25355((class_2561)message);
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        TraderData trader = this.getTrader();
        if (trader != null) {
            this.buttonToggleNotifications.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, trader.notificationsEnabled() ? 200 : 220);
            this.buttonToggleChatNotifications.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, trader.notificationsToChat() ? 200 : 220);
        }
    }

    @Override
    public void closeTab() {
    }

    private void ToggleNotifications(class_4185 button) {
        class_2487 message = new class_2487();
        message.method_10556("Notifications", !this.getTrader().notificationsEnabled());
        this.getTrader().sendNetworkMessage(message);
    }

    private void ToggleChatNotifications(class_4185 button) {
        class_2487 message = new class_2487();
        message.method_10556("NotificationsToChat", !this.getTrader().notificationsToChat());
        this.getTrader().sendNetworkMessage(message);
    }

    private void ToggleTeamNotificationLevel(class_4185 button) {
        class_2487 message = new class_2487();
        message.method_10569("TeamNotificationLevel", Team.NextBankLimit(this.getTrader().teamNotificationLevel()));
        this.getTrader().sendNetworkMessage(message);
    }
}

