/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.base;

import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TraderSelectClientTab
extends TraderInterfaceClientTab<TraderSelectTab>
implements ScrollBarWidget.IScrollable {
    class_342 searchField;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons;
    private int scroll;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    public TraderSelectClientTab(TraderInterfaceScreen screen, TraderSelectTab tab) {
        super(screen, tab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of(ModBlocks.TERMINAL);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.interface.trader");
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private List<TraderData> traderList() {
        List<TraderData> traderList = this.filterTraders(TraderSaveData.GetAllTerminalTraders(true));
        traderList.sort(TradingTerminalScreen.TERMINAL_SORTER);
        return traderList;
    }

    private List<TraderData> filterTraders(List<TraderData> allTraders) {
        ArrayList<TraderData> traders = new ArrayList<TraderData>();
        TraderInterfaceBlockEntity be = this.menu.getTraderInterface();
        if (be == null) {
            return traders;
        }
        TraderInterfaceBlockEntity.InteractionType interaction = be.getInteractionType();
        for (TraderData trader : allTraders) {
            if (!be.validTraderType(trader) || (!interaction.trades || !trader.hasValidTrade()) && (!interaction.requiresPermissions || !be.hasTraderPermissions(trader))) continue;
            traders.add(trader);
        }
        return traders;
    }

    @Override
    public void onOpen() {
        this.searchField = this.screen.addRenderableTabWidget(new class_342(this.font, this.screen.getGuiLeft() + 43, this.screen.getGuiTop() + 6, 101, 9, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.terminal.search")));
        this.searchField.method_1858(false);
        this.searchField.method_1880(32);
        this.searchField.method_1868(0xFFFFFF);
        this.initTraderButtons(this.screen.getGuiLeft(), this.screen.getGuiTop());
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 30 + 146, this.screen.getGuiTop() + 18, 120, this));
        this.tick();
        this.updateTraderList();
        TraderData selectedTrader = this.menu.getTraderInterface().getTrader();
        if (selectedTrader != null) {
            this.scroll = this.scrollOf(selectedTrader);
            this.updateTraderButtons();
        }
        this.screen.addTabListener(new ScrollListener(0, 0, this.screen.field_22789, this.screen.field_22790, this::onMouseScrolled));
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 4; ++y) {
            NetworkTraderButton newButton = this.screen.addRenderableTabWidget(new NetworkTraderButton(guiLeft + 30, guiTop + 18 + y * 30, this::SelectTrader, this.font));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(TraderInterfaceScreen.GUI_TEXTURE, this.screen.getGuiLeft() + 28, this.screen.getGuiTop() + 4, 0, 236, 117, 12);
        this.scrollBar.beforeWidgetRender(mouseY);
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.searchField.method_1865();
        for (NetworkTraderButton button : this.traderButtons) {
            button.selected = button.getData() != null && button.getData() == this.menu.getTraderInterface().getTrader();
        }
    }

    @Override
    public boolean charTyped(char c, int code) {
        String s = this.searchField.method_1882();
        if (this.searchField.method_25400(c, code)) {
            if (!Objects.equals(s, this.searchField.method_1882())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int mods) {
        String s = this.searchField.method_1882();
        if (this.searchField.method_25404(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.method_1882())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    private void SelectTrader(class_4185 button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            long traderID = this.filteredTraderList.get(index).getID();
            ((TraderSelectTab)this.commonTab).setTrader(traderID);
        }
    }

    private int getTraderIndex(class_4185 button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += this.scroll;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(this.filteredTraderList.size() - this.traderButtons.size(), 0);
    }

    private int scrollOf(TraderData trader) {
        if (this.filteredTraderList != null) {
            int index = this.filteredTraderList.indexOf(trader);
            if (index >= 0) {
                return Math.min(index, this.getMaxScroll());
            }
            return this.scroll;
        }
        return this.scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = TraderSearchFilter.FilterTraders(this.traderList(), this.searchField.method_1882());
        this.updateTraderButtons();
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.min(newScroll, this.getMaxScroll());
        this.updateTraderButtons();
    }

    private boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll < this.getMaxScroll()) {
                this.setScroll(this.scroll + 1);
            }
        } else if (delta > 0.0 && this.scroll > 0) {
            this.setScroll(this.scroll - 1);
        }
        return false;
    }
}

