/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.base;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class OwnershipClientTab
extends TraderInterfaceClientTab<OwnershipTab> {
    class_342 newOwnerInput;
    class_4185 buttonSetOwner;
    TeamSelectWidget teamSelection;
    class_4185 buttonSetTeamOwner;
    long selectedTeam = -1L;
    List<Team> teamList = Lists.newArrayList();
    IconButton buttonToggleMode;
    boolean playerMode = true;

    public OwnershipClientTab(TraderInterfaceScreen screen, OwnershipTab tab) {
        super(screen, tab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8575);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.owner");
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void onOpen() {
        this.newOwnerInput = this.screen.addRenderableTabWidget(new class_342(this.font, this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 26, 160, 20, (class_2561)class_2561.method_43473()));
        this.newOwnerInput.method_1880(16);
        this.buttonSetOwner = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 47, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.set_owner"), this::setOwner));
        this.buttonSetOwner.field_22763 = false;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 13, this.screen.getGuiTop() + 25, 4, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.font);
        this.buttonSetTeamOwner = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 117, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.set_owner"), this::setTeamOwner));
        this.buttonSetTeamOwner.field_22763 = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getImageWidth() - 20 - 3, this.screen.getGuiTop() + 3, this::toggleMode, this::getModeIcon, (Supplier<class_7919>)new IconAndButtonUtil.ToggleTooltip(() -> this.playerMode, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.owner.player"), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.owner.team"))));
        this.tick();
    }

    private IconData getModeIcon() {
        return this.playerMode ? IconData.of((class_1935)class_1802.field_8575) : IconData.of((class_1935)class_1802.field_8674);
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.menu.getTraderInterface() == null) {
            return;
        }
        gui.method_51439(this.font, TextRenderUtil.fitString((class_2561)class_2561.method_43469((String)"gui.button.lightmanscurrency.team.owner", (Object[])new Object[]{this.menu.getTraderInterface().getOwnerName()}), this.screen.getImageWidth() - 20), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 10, 0x404040, false);
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        if (this.menu.getTraderInterface() == null) {
            return;
        }
        if (this.buttonSetOwner.method_25405((double)mouseX, (double)mouseY) || this.buttonSetTeamOwner.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.font, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.warning").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}), mouseX, mouseY);
        }
    }

    private void toggleMode(class_4185 button) {
        this.playerMode = !this.playerMode;
    }

    private void setOwner(class_4185 button) {
        if (this.newOwnerInput.method_1882().isBlank()) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewOwner(this.newOwnerInput.method_1882());
        this.newOwnerInput.method_1852("");
    }

    private void setTeamOwner(class_4185 button) {
        if (this.selectedTeam < 0L) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewTeam(this.selectedTeam);
        this.selectedTeam = -1L;
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID() == this.selectedTeam ? -1L : newTeam.getID();
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.newOwnerInput.method_1865();
        this.buttonSetOwner.field_22764 = this.newOwnerInput.field_22764 = this.playerMode;
        this.teamSelection.field_22764 = !this.playerMode;
        this.buttonSetTeamOwner.field_22764 = this.teamSelection.field_22764;
        this.buttonSetOwner.field_22763 = !this.newOwnerInput.method_1882().isBlank();
        this.buttonSetTeamOwner.field_22763 = this.getSelectedTeam() != null;
    }

    @Override
    public void onClose() {
        this.selectedTeam = -1L;
        this.teamList = Lists.newArrayList();
    }
}

