/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.menu.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageATMSetPlayerAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSelectBankAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class SelectionTab
extends ATMTab {
    class_4185 buttonPersonalAccount;
    TeamSelectWidget teamSelection;
    class_4185 buttonToggleAdminMode;
    class_342 playerAccountSelect;
    class_4185 buttonSelectPlayerAccount;
    class_2561 responseMessage = class_2561.method_43473();
    boolean adminMode = false;

    public SelectionTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8407);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.selection");
    }

    @Override
    public void init() {
        this.adminMode = false;
        this.responseMessage = class_2561.method_43473();
        SimpleSlot.SetInactive(this.screen.method_17577());
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 79, this.screen.getGuiTop() + 15, 6, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.buttonPersonalAccount = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 15, 70, 20, (class_2561)class_2561.method_43471((String)"gui.button.bank.playeraccount"), this::PressPersonalAccount));
        this.buttonToggleAdminMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getImageWidth(), this.screen.getGuiTop(), this::ToggleAdminMode, IconData.of((class_1935)class_1802.field_8866)));
        this.buttonToggleAdminMode.field_22764 = CommandLCAdmin.isAdminPlayer(((ATMMenu)this.screen.method_17577()).getPlayer());
        this.playerAccountSelect = this.screen.addRenderableTabWidget(new class_342(this.screen.getFont(), this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 20, 162, 20, (class_2561)class_2561.method_43473()));
        this.playerAccountSelect.field_22764 = false;
        this.buttonSelectPlayerAccount = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 45, 162, 20, (class_2561)class_2561.method_43471((String)"gui.button.bank.admin.playeraccount"), this::PressSelectPlayerAccount));
        this.buttonSelectPlayerAccount.field_22764 = false;
        this.tick();
    }

    private boolean isTeamSelected() {
        return ((ATMMenu)this.screen.method_17577()).getBankAccountReference().accountType == BankAccount.AccountType.Team;
    }

    private boolean isSelfSelected() {
        return ((ATMMenu)this.screen.method_17577()).getBankAccount() == BankAccount.GenerateReference(((ATMMenu)this.screen.method_17577()).getPlayer()).get();
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((ATMMenu)this.screen.method_17577()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.isTeamSelected()) {
            return TeamSaveData.GetTeam(true, ((ATMMenu)this.screen.method_17577()).getBankAccountReference().teamID);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            Team selectedTeam = this.selectedTeam();
            if (selectedTeam != null && team.getID() == selectedTeam.getID()) {
                return;
            }
            BankAccount.AccountReference account = BankAccount.GenerateReference(true, team);
            new CMessageSelectBankAccount(account).sendToServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(class_4185 button) {
        BankAccount.AccountReference account = BankAccount.GenerateReference(((ATMMenu)this.screen.method_17577()).getPlayer());
        new CMessageSelectBankAccount(account).sendToServer();
    }

    private void ToggleAdminMode(class_4185 button) {
        this.adminMode = !this.adminMode;
        this.buttonPersonalAccount.field_22764 = !this.adminMode;
        this.teamSelection.field_22764 = !this.adminMode;
        this.buttonSelectPlayerAccount.field_22764 = this.adminMode;
        this.playerAccountSelect.field_22764 = this.adminMode;
    }

    private void PressSelectPlayerAccount(class_4185 button) {
        String playerName = this.playerAccountSelect.method_1882();
        this.playerAccountSelect.method_1852("");
        if (!playerName.isBlank()) {
            new CMessageATMSetPlayerAccount(playerName).sendToServer();
        }
    }

    public void ReceiveSelectPlayerResponse(class_2561 message) {
        this.responseMessage = message;
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.hideCoinSlots(gui);
        gui.method_51439(this.screen.getFont(), (class_2561)this.getTooltip(), this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, 0x404040, false);
        if (this.adminMode) {
            List lines = this.screen.getFont().method_27527().method_27495((class_5348)this.responseMessage, this.screen.getImageWidth() - 15, class_2583.field_24360);
            for (int i = 0; i < lines.size(); ++i) {
                class_327 class_3272 = this.screen.getFont();
                String string = ((class_5348)lines.get(i)).getString();
                int n = this.screen.getGuiLeft() + 7;
                int n2 = this.screen.getGuiTop() + 70;
                Objects.requireNonNull(this.screen.getFont());
                gui.method_51433(class_3272, string, n, n2 + 9 * i, 0x404040, false);
            }
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY) {
        if (this.getTeamList().size() == 0 && !this.adminMode) {
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.bank.noteamsavailable"), this.teamSelection.method_46426() + 1, TeamButton.Size.NARROW.width - 2, this.teamSelection.method_46427() + 1, this.teamSelection.method_25364() - 2, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.field_22763 = !this.isSelfSelected();
        this.buttonToggleAdminMode.field_22764 = CommandLCAdmin.isAdminPlayer(((ATMMenu)this.screen.method_17577()).getPlayer());
        if (this.adminMode) {
            this.playerAccountSelect.method_1865();
        }
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.method_17577());
    }
}

