/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSetBankNotificationLevel;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class NotificationTab
extends ATMTab {
    CoinValueInput notificationSelection;

    public NotificationTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8634);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.notification");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.method_17577());
        class_2561 accountName = ((ATMMenu)this.screen.method_17577()).getPlayer().method_5476();
        if (((ATMMenu)this.screen.method_17577()).getBankAccount() != null) {
            accountName = ((ATMMenu)this.screen.method_17577()).getBankAccount().getName();
        }
        this.notificationSelection = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft(), this.screen.getGuiTop(), accountName, ((ATMMenu)this.screen.method_17577()).getBankAccount().getNotificationValue(), this.screen.getFont(), this::onValueChanged, this.screen::addRenderableTabWidget));
        this.notificationSelection.drawBG = false;
        this.notificationSelection.allowFreeToggle = false;
        this.notificationSelection.init();
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.hideCoinSlots(gui);
        BankAccount account = ((ATMMenu)this.screen.method_17577()).getBankAccount();
        if (account != null) {
            TextRenderUtil.drawCenteredMultilineText(gui, (class_2561)(account.getNotificationLevel() > 0L ? class_2561.method_43469((String)"gui.lightmanscurrency.notification.details", (Object[])new Object[]{account.getNotificationValue().getString()}) : class_2561.method_43471((String)"gui.lightmanscurrency.notification.disabled")), this.screen.getGuiLeft() + 5, this.screen.getImageWidth() - 10, this.screen.getGuiTop() + 70, 0x404040);
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.notificationSelection.tick();
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.method_17577());
    }

    public void onValueChanged(CoinValue value) {
        ((ATMMenu)this.screen.method_17577()).getBankAccount().setNotificationValue(value);
        new CMessageSetBankNotificationLevel(value).sendToServer();
    }
}

