/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menu.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.TraderInterfaceTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class TraderInterfaceScreen
extends MenuScreen<TraderInterfaceMenu>
implements TraderInterfaceMenu.IClientMessage {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/trader_interface.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    Map<Integer, TraderInterfaceClientTab<?>> availableTabs = new HashMap();
    Map<Integer, TabButton> tabButtons = new HashMap<Integer, TabButton>();
    List<class_339> tabRenderables = new ArrayList<class_339>();
    List<class_364> tabListeners = new ArrayList<class_364>();
    IconButton modeToggle;
    IconButton onlineModeToggle;

    public TraderInterfaceClientTab<?> currentTab() {
        return this.availableTabs.get(((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex());
    }

    public TraderInterfaceScreen(TraderInterfaceMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        ((TraderInterfaceMenu)this.field_2797).getAllTabs().forEach((key, tab) -> this.availableTabs.put((Integer)key, tab.createClientTab(this)));
        this.field_2792 = 206;
        this.field_2779 = 236;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.tabButtons.clear();
        this.availableTabs.forEach((key, tab) -> {
            TabButton newButton = (TabButton)this.method_37063((class_364)new TabButton(button -> this.changeTab((int)key), this.field_22793, (ITab)tab));
            if (key.intValue() == ((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex()) {
                newButton.field_22763 = false;
            }
            this.tabButtons.put((Integer)key, newButton);
        });
        this.modeToggle = (IconButton)this.method_37063((class_364)new IconButton(this.field_2776 + this.field_2792, this.field_2800, this::ToggleMode, () -> IconAndButtonUtil.GetIcon(((TraderInterfaceMenu)this.field_2797).getTraderInterface().getMode()), (Supplier<class_7919>)new IconAndButtonUtil.SuppliedTooltip(() -> this.getMode().getDisplayText())));
        this.onlineModeToggle = (IconButton)this.method_37063((class_364)new IconButton(this.field_2776 + this.field_2792, this.field_2800 + 20, this::ToggleOnlineMode, () -> ((TraderInterfaceMenu)this.field_2797).getTraderInterface().isOnlineMode() ? IconAndButtonUtil.ICON_ONLINEMODE_TRUE : IconAndButtonUtil.ICON_ONLINEMODE_FALSE, (Supplier<class_7919>)new IconAndButtonUtil.SuppliedTooltip(() -> class_2561.method_43471((String)("gui.lightmanscurrency.interface.onlinemode." + ((TraderInterfaceMenu)this.field_2797).getTraderInterface().isOnlineMode())))));
        this.currentTab().onOpen();
        this.method_37432();
    }

    protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(GUI_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        try {
            this.currentTab().renderBG(gui, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab " + this.currentTab().getClass().getName(), e);
        }
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        gui.method_51439(this.field_22793, this.field_29347, 23, this.field_2779 - 94, 0x404040, false);
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gui);
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        this.method_2380(gui, mouseX, mouseY);
        try {
            this.currentTab().renderTooltips(gui, mouseX, mouseY);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab tooltips " + this.currentTab().getClass().getName(), e);
        }
        this.tabButtons.forEach((key, button) -> {
            if (button.method_25405(mouseX, mouseY)) {
                gui.method_51438(this.field_22793, (class_2561)button.tab.getTooltip(), mouseX, mouseY);
            }
        });
    }

    @Override
    protected void method_37432() {
        if (!((TraderInterfaceTab)this.currentTab().commonTab).canOpen(((TraderInterfaceMenu)this.field_2797).player)) {
            this.changeTab(0);
        }
        this.updateTabs();
        this.currentTab().tick();
    }

    private TraderInterfaceBlockEntity.ActiveMode getMode() {
        if (((TraderInterfaceMenu)this.field_2797).getTraderInterface() != null) {
            return ((TraderInterfaceMenu)this.field_2797).getTraderInterface().getMode();
        }
        return TraderInterfaceBlockEntity.ActiveMode.DISABLED;
    }

    private void ToggleMode(class_4185 button) {
        ((TraderInterfaceMenu)this.field_2797).changeMode(this.getMode().getNext());
    }

    private void ToggleOnlineMode(class_4185 button) {
        ((TraderInterfaceMenu)this.field_2797).setOnlineMode(!((TraderInterfaceMenu)this.field_2797).getTraderInterface().isOnlineMode());
    }

    private void updateTabs() {
        int yPos = this.field_2800 - 25;
        AtomicInteger index = new AtomicInteger(0);
        this.tabButtons.forEach((key, button) -> {
            TraderInterfaceClientTab<?> tab = this.availableTabs.get(key);
            button.field_22764 = tab.tabButtonVisible();
            if (button.field_22764) {
                int xPos = this.field_2776 + 25 * index.get();
                button.reposition(xPos, yPos, 0);
                index.set(index.get() + 1);
            }
        });
    }

    public boolean method_25404(int key, int scanCode, int mods) {
        if (this.currentTab().keyPressed(key, scanCode, mods)) {
            return true;
        }
        if (this.field_22787 == null) {
            return super.method_25404(key, scanCode, mods);
        }
        if (this.field_22787.field_1690.field_1822.method_1417(key, scanCode) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.method_25404(key, scanCode, mods);
    }

    private TabButton getTabButton(int key) {
        if (this.tabButtons.containsKey(key)) {
            return this.tabButtons.get(key);
        }
        return null;
    }

    public void changeTab(int newTab) {
        this.changeTab(newTab, true, null);
    }

    public void changeTab(int newTab, boolean sendMessage, class_2487 selfMessage) {
        if (newTab == ((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex()) {
            return;
        }
        int oldTab = ((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex();
        this.currentTab().onClose();
        TabButton button = this.getTabButton(((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex());
        if (button != null) {
            button.field_22763 = true;
        }
        this.tabRenderables.clear();
        this.tabListeners.clear();
        ((TraderInterfaceMenu)this.field_2797).changeTab(newTab, new class_2487());
        button = this.getTabButton(((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex());
        if (button != null) {
            button.field_22763 = false;
        }
        if (selfMessage != null) {
            this.currentTab().receiveSelfMessage(selfMessage);
        }
        this.currentTab().onOpen();
        if (oldTab != ((TraderInterfaceMenu)this.field_2797).getCurrentTabIndex() && sendMessage) {
            ((TraderInterfaceMenu)this.field_2797).sendMessage(((TraderInterfaceMenu)this.field_2797).createTabChangeMessage(newTab, null));
        }
    }

    @Override
    public void selfMessage(class_2487 message) {
        if (message.method_10573("ChangeTab", 3)) {
            this.changeTab(message.method_10550("ChangeTab"), false, message);
        } else {
            this.currentTab().receiveSelfMessage(message);
        }
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends class_339> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends class_364> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25400(char c, int code) {
        if (this.currentTab().charTyped(c, code)) {
            return true;
        }
        return super.method_25400(c, code);
    }
}

