/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenStorage;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenTrades;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class TraderSettingsScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/tradersettings.png");
    private final Supplier<TraderData> trader;
    public final int xSize = 200;
    public final int ySize = 200;
    List<class_339> tabWidgets = Lists.newArrayList();
    List<class_364> tabListeners = Lists.newArrayList();
    List<TabButton> tabButtons = Lists.newArrayList();
    List<SettingsTab> tabs;
    int currentTabIndex = 0;

    public class_1657 getPlayer() {
        return this.field_22787.field_1724;
    }

    public TraderData getTrader() {
        return this.trader.get();
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.field_22789 - 200) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.field_22790 - 200) / 2;
    }

    public SettingsTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public TraderSettingsScreen(Supplier<TraderData> trader) {
        super((class_2561)class_2561.method_43473());
        this.trader = trader;
        this.tabs = this.trader.get().getSettingsTabs();
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public void method_25426() {
        this.method_37063((class_364)new IconButton(this.guiLeft(), this.guiTop() - 20, this::OpenStorage, IconAndButtonUtil.ICON_BACK));
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.method_37063((class_364)new TabButton(this::clickedOnTab, this.field_22793, this.tabs.get(i)));
            button.field_22763 = i != this.currentTabIndex;
            button.field_22764 = this.tabs.get(i).canOpen();
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        try {
            this.currentTab().initTab();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error in Settings Tab init.", t);
        }
    }

    private int getTabPosX(int index) {
        if (index < 7) {
            return this.guiLeft() + 20 + 25 * index;
        }
        if (index < 15) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200;
        }
        if (index < 23) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 7) {
            return this.guiTop() - 25;
        }
        if (index < 15) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 23) {
            int n = this.guiTop();
            Objects.requireNonNull(this);
            return n + 200;
        }
        int n = this.guiTop();
        Objects.requireNonNull(this);
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 7) {
            return 0;
        }
        if (index < 15) {
            return 1;
        }
        if (index < 23) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (TabButton thisButton : this.tabButtons) {
            if (!thisButton.field_22764) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gui);
        this.setColor(gui, this.currentTab().getColor());
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        gui.method_25302(GUI_TEXTURE, n, n2, 0, 0, 200, 200);
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        try {
            this.currentTab().preRender(gui, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error in Settings Tab pre-render.", t);
        }
        this.tabWidgets.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
        try {
            this.currentTab().postRender(gui, mouseX, mouseY, partialTicks);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error in Settings Tab post-render.", t);
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.method_25405(mouseX, mouseY)) continue;
            gui.method_51438(this.field_22793, (class_2561)tabButton.tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void setColor(class_332 gui, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        gui.method_51422(r, g, b, 1.0f);
    }

    public void method_25393() {
        if (this.field_22787 == null) {
            return;
        }
        if (this.getTrader() == null) {
            this.field_22787.method_1507(null);
            return;
        }
        if (!this.hasPermission("editSettings")) {
            this.field_22787.method_1507(null);
            if (this.hasPermission("openStorage")) {
                new CMessageOpenStorage(this.getTrader().getID()).sendToServer();
            } else {
                new CMessageOpenTrades(this.getTrader().getID()).sendToServer();
            }
            return;
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.tabs.get(i).canOpen();
            if (visible == this.tabButtons.get((int)i).field_22764) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).field_22764 = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        if (!this.currentTab().canOpen()) {
            this.clickedOnTab(this.tabButtons.get(0));
        }
        try {
            this.currentTab().tick();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error in Settings Tab tick.", t);
        }
    }

    public boolean hasPermission(String permission) {
        if (this.trader.get() != null) {
            return this.trader.get().hasPermission(this.getPlayer(), permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        if (this.trader.get() != null) {
            return this.trader.get().getPermissionLevel(this.getPlayer(), permission);
        }
        return 0;
    }

    public boolean hasPermissions(List<String> permissions) {
        for (String permission : permissions) {
            if (this.hasPermission(permission)) continue;
            return false;
        }
        return true;
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(class_339 widget) {
        this.tabWidgets.remove(widget);
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(class_364 listener) {
        this.tabListeners.remove(listener);
    }

    private void clickedOnTab(class_4185 tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        if (tabIndex != this.currentTabIndex) {
            try {
                this.currentTab().closeTab();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error in Settings Tab close.", t);
            }
            this.tabButtons.get((int)this.currentTabIndex).field_22763 = true;
            this.currentTabIndex = tabIndex;
            this.tabButtons.get((int)this.currentTabIndex).field_22763 = false;
            this.tabWidgets.clear();
            this.tabListeners.clear();
            try {
                this.currentTab().initTab();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error in Settings Tab init.", t);
            }
        }
    }

    private void OpenStorage(class_4185 button) {
        new CMessageOpenStorage(this.getTrader().getID()).sendToServer();
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25421() {
        return false;
    }
}

