/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.data.ClientNotificationData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.MarkAsSeenButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.NotificationTabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.network.server.messages.notifications.CMessageFlagNotificationsSeen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class NotificationScreen
extends class_437
implements ScrollBarWidget.IScrollable {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/notifications.png");
    public final int xSize = 200;
    public final int ySize = 200;
    public final int TABS_PER_PAGE = 8;
    public final int NOTIFICATIONS_PER_PAGE = 8;
    public final int NOTIFICATION_HEIGHT = 22;
    List<NotificationTabButton> tabButtons;
    int tabScroll = 0;
    NotificationCategory selectedCategory = NotificationCategory.GENERAL;
    ScrollBarWidget notificationScroller = null;
    class_4185 buttonMarkAsSeen;
    int notificationScroll = 0;

    public static void open() {
        if (RenderSystem.isOnRenderThread()) {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new NotificationScreen());
        } else {
            ScreenUtil.safelyOpenScreen(new NotificationScreen());
        }
    }

    public final NotificationData getNotifications() {
        return ClientNotificationData.GetNotifications();
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.field_22789 - 200 - 25) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.field_22790 - 200) / 2;
    }

    public NotificationScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public boolean method_25421() {
        return false;
    }

    public List<NotificationCategory> getCategories() {
        ArrayList categories = Lists.newArrayList((Object[])new NotificationCategory[]{NotificationCategory.GENERAL});
        categories.addAll(this.getNotifications().getCategories().stream().filter(cat -> cat != NotificationCategory.GENERAL).toList());
        return categories;
    }

    public void reinit() {
        this.method_37067();
        this.validateSelectedCategory();
        this.method_25426();
    }

    public void method_25426() {
        this.tabButtons = new ArrayList<NotificationTabButton>();
        for (NotificationCategory cat : this.getCategories()) {
            this.tabButtons.add((NotificationTabButton)this.method_37063((class_364)new NotificationTabButton(this::SelectTab, this.field_22793, this::getNotifications, cat)));
        }
        this.positionTabButtons();
        int n = this.guiLeft() + 25;
        Objects.requireNonNull(this);
        int n2 = n + 200 - 15;
        int n3 = this.guiTop() + 15;
        Objects.requireNonNull(this);
        this.notificationScroller = (ScrollBarWidget)this.method_37063((class_364)new ScrollBarWidget(n2, n3, 8 * this.NOTIFICATION_HEIGHT, this));
        int n4 = this.guiLeft();
        Objects.requireNonNull(this);
        this.buttonMarkAsSeen = (class_4185)this.method_37063((class_364)new MarkAsSeenButton(n4 + 200 + 25 - 15, this.guiTop() + 4, (class_2561)class_2561.method_43471((String)"gui.button.notifications.mark_read"), this::markAsRead));
        this.method_25393();
    }

    private void validateSelectedCategory() {
        List<NotificationCategory> categories = this.getCategories();
        boolean categoryFound = false;
        for (int i = 0; i < categories.size() && !categoryFound; ++i) {
            if (!categories.get(i).matches(this.selectedCategory)) continue;
            categoryFound = true;
        }
        if (!categoryFound || this.selectedCategory == null) {
            this.selectedCategory = NotificationCategory.GENERAL;
        }
    }

    private void positionTabButtons() {
        int startIndex = this.tabScroll = Math.min(this.tabScroll, this.getMaxTabScroll());
        int xPos = this.guiLeft();
        int yPos = this.guiTop();
        List<NotificationCategory> categories = this.getCategories();
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton tab = this.tabButtons.get(i);
            if (i >= startIndex && i < startIndex + 8) {
                tab.field_22764 = true;
                tab.reposition(xPos, yPos, 3);
                tab.field_22763 = i < categories.size() ? !categories.get(i).matches(this.selectedCategory) : true;
                yPos += 25;
                continue;
            }
            tab.field_22764 = false;
        }
    }

    public void method_25393() {
        this.buttonMarkAsSeen.field_22763 = this.getNotifications().unseenNotification(this.selectedCategory);
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gui);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int screenLeft = this.guiLeft() + 25;
        int n = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        gui.method_25302(GUI_TEXTURE, screenLeft, n, 0, 0, 200, 200);
        this.notificationScroller.beforeWidgetRender(mouseY);
        this.notificationScroll = Math.min(this.notificationScroll, this.getMaxNotificationScroll());
        List<Notification> notifications = this.getNotifications().getNotifications(this.selectedCategory);
        class_5250 tooltip = null;
        int index = this.notificationScroll;
        for (int y = 0; y < 8 && index < notifications.size(); ++y) {
            class_5250 message;
            List lines;
            int n2;
            Notification not = notifications.get(index++);
            int yPos = this.guiTop() + 15 + y * 22;
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (not.wasSeen()) {
                Objects.requireNonNull(this);
                n2 = 200;
            } else {
                Objects.requireNonNull(this);
                n2 = 200 + 22;
            }
            int vPos = n2;
            int textColor = not.wasSeen() ? 0xFFFFFF : 0;
            gui.method_25302(GUI_TEXTURE, screenLeft + 15, yPos, 0, vPos, 170, 22);
            int textXPos = screenLeft + 17;
            int textWidth = 166;
            if (not.getCount() > 1) {
                String countText = String.valueOf(not.getCount());
                int quantityWidth = this.field_22793.method_1727(countText);
                gui.method_25302(GUI_TEXTURE, screenLeft + 16 + quantityWidth, yPos, 170, vPos, 3, 22);
                Objects.requireNonNull(this.field_22793);
                gui.method_51433(this.field_22793, countText, textXPos, yPos + 11 - 9 / 2, textColor, false);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            if ((lines = this.field_22793.method_1728((class_5348)(message = this.selectedCategory == NotificationCategory.GENERAL ? not.getGeneralMessage() : not.getMessage()), textWidth)).size() == 1) {
                class_5481 class_54812 = (class_5481)lines.get(0);
                Objects.requireNonNull(this.field_22793);
                gui.method_51430(this.field_22793, class_54812, textXPos, yPos + 11 - 9 / 2, textColor, false);
                continue;
            }
            for (int l = 0; l < lines.size() && l < 2; ++l) {
                gui.method_51430(this.field_22793, (class_5481)lines.get(l), textXPos, yPos + 2 + l * 10, textColor, false);
            }
            if (lines.size() <= 2 || tooltip != null || mouseX < screenLeft + 15 || mouseX >= screenLeft + 185 || mouseY < yPos || mouseY >= yPos + 22) continue;
            tooltip = message;
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        for (NotificationTabButton tab : this.tabButtons) {
            tab.renderTooltip(gui, mouseX, mouseY);
        }
        if (tooltip != null) {
            gui.method_51447(this.field_22793, this.field_22793.method_1728(tooltip, 170), mouseX, mouseY);
        }
    }

    private void SelectTab(class_4185 button) {
        NotificationCategory newCategory;
        List<NotificationCategory> categories;
        int tabIndex = this.tabButtons.indexOf(button);
        if (tabIndex >= 0 && tabIndex < (categories = this.getCategories()).size() && !(newCategory = categories.get(tabIndex)).matches(this.selectedCategory)) {
            this.selectedCategory = newCategory;
            this.notificationScroll = 0;
            this.positionTabButtons();
        }
    }

    public int getMaxTabScroll() {
        return Math.max(0, this.tabButtons.size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tabScrolled(double delta) {
        if (delta < 0.0) {
            if (this.tabScroll >= this.getMaxTabScroll()) return false;
            ++this.tabScroll;
            this.positionTabButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.tabScroll <= 0) return false;
            --this.tabScroll;
            this.positionTabButtons();
        }
        return true;
    }

    public int getMaxNotificationScroll() {
        return Math.max(0, this.getNotifications().getNotifications(this.selectedCategory).size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean notificationScrolled(double delta) {
        if (delta < 0.0) {
            if (this.notificationScroll >= this.getMaxNotificationScroll()) return false;
            ++this.notificationScroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.notificationScroll <= 0) return false;
            --this.notificationScroll;
        }
        return true;
    }

    public void markAsRead(class_4185 button) {
        new CMessageFlagNotificationsSeen(this.selectedCategory).sendToServer();
    }

    @Override
    public int currentScroll() {
        return this.notificationScroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.notificationScroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return this.getMaxNotificationScroll();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)(this.guiLeft() + 25)) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            if (mouseX < (double)(n + 200) && mouseY >= (double)this.guiTop()) {
                int n2 = this.guiTop();
                Objects.requireNonNull(this);
                if (mouseY < (double)(n2 + 200)) {
                    if (this.notificationScrolled(delta)) {
                        return true;
                    }
                    return super.method_25401(mouseX, mouseY, delta);
                }
            }
        }
        if (this.tabScrolled(delta)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.notificationScroller.onMouseClicked(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.notificationScroller.onMouseReleased(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int key, int scanCode, int mods) {
        assert (this.field_22787 != null);
        if (this.field_22787.field_1690.field_1822.method_1417(key, scanCode)) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(key, scanCode, mods);
    }
}

