/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.data;

import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class ClientTraderData {
    private static final Map<Long, TraderData> loadedTraders = new HashMap<Long, TraderData>();

    public static List<TraderData> GetAllTraders() {
        return new ArrayList<TraderData>(loadedTraders.values());
    }

    public static TraderData GetTrader(long traderID) {
        if (loadedTraders.containsKey(traderID)) {
            return loadedTraders.get(traderID);
        }
        return null;
    }

    public static void ClearTraders() {
        loadedTraders.clear();
    }

    public static void UpdateTrader(class_2487 compound) {
        long traderID = compound.method_10537("ID");
        if (loadedTraders.containsKey(traderID)) {
            loadedTraders.get(traderID).load(compound);
        } else {
            TraderData trader = TraderData.Deserialize(true, compound);
            if (trader != null) {
                loadedTraders.put(traderID, trader);
            }
        }
    }

    public static void RemoveTrader(long traderID) {
        loadedTraders.remove(traderID);
    }

    public static void onClientLogout(class_634 handler, class_310 client) {
        ClientTraderData.ClearTraders();
    }
}

