/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.data;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public class ClientBankData {
    private static final Map<UUID, BankAccount> loadedBankAccounts = new HashMap<UUID, BankAccount>();
    private static BankAccount.AccountReference lastSelectedAccount = null;

    public static BankAccount GetPlayerBankAccount(UUID playerID) {
        if (loadedBankAccounts.containsKey(playerID)) {
            return loadedBankAccounts.get(playerID);
        }
        LightmansCurrency.LogWarning("No bank account for player with id " + playerID.toString() + " is present on the client.");
        return new BankAccount();
    }

    public static void InitBankAccounts(Map<UUID, BankAccount> bankAccounts) {
        loadedBankAccounts.clear();
        bankAccounts.forEach((id, account) -> loadedBankAccounts.put((UUID)id, (BankAccount)account));
    }

    public static void UpdateBankAccount(class_2487 compound) {
        try {
            UUID owner = compound.method_25926("Player");
            BankAccount account = new BankAccount(compound);
            if (owner != null && account != null) {
                loadedBankAccounts.put(owner, account);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void UpdateLastSelectedAccount(BankAccount.AccountReference reference) {
        lastSelectedAccount = reference;
    }

    public static BankAccount.AccountReference GetLastSelectedAccount() {
        return lastSelectedAccount;
    }

    public static void onClientLogout(class_634 handler, class_310 client) {
        loadedBankAccounts.clear();
        lastSelectedAccount = null;
    }
}

