/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.client.ClientEventListeners;
import io.github.lightman314.lightmanscurrency.client.ModLayerDefinitions;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.data.ClientBankData;
import io.github.lightman314.lightmanscurrency.client.data.ClientEjectionData;
import io.github.lightman314.lightmanscurrency.client.data.ClientNotificationData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTeamData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTraderData;
import io.github.lightman314.lightmanscurrency.client.data.ClientWalletData;
import io.github.lightman314.lightmanscurrency.client.gui.overlay.WalletDisplayOverlay;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.SlotMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.client.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.core.groups.BlockConvertible;
import io.github.lightman314.lightmanscurrency.common.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinItem;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.PacketChannels;
import io.github.lightman314.lightmanscurrency.network.client.LCClientPacketHandler;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import net.minecraft.class_5616;

public class LightmansCurrencyClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketChannels.SERVER_TO_CLIENT, (ClientPlayNetworking.PlayChannelHandler)new LCClientPacketHandler());
        this.setRenderLayer(class_1921.method_23581(), ModBlocks.DISPLAY_CASE, ModBlocks.VENDING_MACHINE, ModBlocks.VENDING_MACHINE_LARGE, ModBlocks.ARMOR_DISPLAY);
        this.setRenderLayer(class_1921.method_23583(), ModBlocks.GEM_TERMINAL);
        class_3929.method_17542(ModMenus.ATM, ATMScreen::new);
        class_3929.method_17542(ModMenus.MINT, MintScreen::new);
        class_3929.method_17542(ModMenus.TICKET_MACHINE, TicketMachineScreen::new);
        class_3929.method_17542(ModMenus.TRADER_INTERFACE, TraderInterfaceScreen::new);
        class_3929.method_17542(ModMenus.TRADER_RECOVERY, TraderRecoveryScreen::new);
        class_3929.method_17542(ModMenus.TRADER, TraderScreen::new);
        class_3929.method_17542(ModMenus.TRADER_BLOCK, TraderScreen::new);
        class_3929.method_17542(ModMenus.TRADER_NETWORK_ALL, TraderScreen::new);
        class_3929.method_17542(ModMenus.TRADER_STORAGE, TraderStorageScreen::new);
        class_3929.method_17542(ModMenus.WALLET_BANK, WalletBankScreen::new);
        class_3929.method_17542(ModMenus.WALLET, WalletScreen::new);
        class_3929.method_17542(ModMenus.SLOT_MACHINE, SlotMachineScreen::new);
        class_5616.method_32144(ModBlockEntities.ITEM_TRADER, ItemTraderBlockEntityRenderer::new);
        class_5616.method_32144(ModBlockEntities.FREEZER_TRADER, FreezerTraderBlockEntityRenderer::new);
        class_5616.method_32144(ModBlockEntities.SLOT_MACHINE, SlotMachineBlockEntityRenderer::new);
        ColorProviderRegistry.ITEM.register((Object)new TicketColor(), (Object[])new class_1935[]{ModItems.TICKET, ModItems.TICKET_MASTER});
        EntityModelLayerRegistry.registerModelLayer((class_5601)ModLayerDefinitions.WALLET, WalletLayer::createLayer);
        this.registerEventListeners();
        ClientEventListeners.init();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> SyncedConfigFile.onClientLeavesServer());
        WalletDisplayOverlay.setup();
    }

    private void setRenderLayer(class_1921 layer, BlockConvertible ... blocks) {
        for (BlockConvertible block : blocks) {
            for (class_2248 b : block.asBlock()) {
                BlockRenderLayerMap.INSTANCE.putBlocks(layer, new class_2248[]{b});
            }
        }
    }

    private void registerEventListeners() {
        WorldRenderEvents.START.register(ScreenUtil::onRenderTick);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(WalletLayer::registerLayer);
        ClientPlayConnectionEvents.INIT.register((handler, client) -> ItemEditWidget.initItemList());
        ClientPlayConnectionEvents.INIT.register((handler, client) -> ConfigFile.loadClientFiles(ConfigFile.LoadPhase.GAME_START));
        ClientPlayConnectionEvents.DISCONNECT.register(ClientBankData::onClientLogout);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientEjectionData::onClientLogout);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientNotificationData::onClientLogout);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientTeamData::onClientLogout);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientTraderData::onClientLogout);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientWalletData::onClientLogout);
        ItemTooltipCallback.EVENT.register(this::appendTooltips);
    }

    private void appendTooltips(class_1799 stack, class_1836 context, List<class_2561> lines) {
        if (MoneyUtil.isCoin(stack) && !(stack.method_7909() instanceof CoinItem) && !(stack.method_7909() instanceof CoinBlockItem)) {
            CoinItem.addCoinTooltips(stack, lines);
        }
    }
}

